/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.engine.runtime.Execution;
import org.flowable.rest.service.api.runtime.process.ExecutionBaseResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Executions"}, description="Manage Executions", authorizations={@Authorization(value="basicAuth")})
public class ExecutionActiveActivitiesCollectionResource
extends ExecutionBaseResource {
    @ApiOperation(value="List active activities in an execution", nickname="listExecutionActiveActivities", tags={"Executions"}, notes="Returns all activities which are active in the execution and in all child-executions (and their children, recursively), if any.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the execution was found and activities are returned."), @ApiResponse(code=404, message="Indicates the execution was not found.")})
    @GetMapping(value={"/runtime/executions/{executionId}/activities"}, produces={"application/json"})
    public List<String> getActiveActivities(@ApiParam(name="executionId") @PathVariable String executionId) {
        Execution execution = this.getExecutionFromRequest(executionId);
        return this.runtimeService.getActiveActivityIds(execution.getId());
    }
}

