/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.task.Event;
import org.flowable.rest.service.api.engine.EventResponse;
import org.flowable.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskEventResource
extends TaskBaseResource {
    @ApiOperation(value="Get an event on a task", tags={"Tasks"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task and event were found and the event is returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the tasks doesn\u2019t have an event with the given ID.")})
    @GetMapping(value={"/runtime/tasks/{taskId}/events/{eventId}"}, produces={"application/json"})
    public EventResponse getEvent(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="eventId") @PathVariable(value="eventId") String eventId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        Event event = this.taskService.getEvent(eventId);
        if (event == null || !task.getId().equals(event.getTaskId())) {
            throw new FlowableObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + eventId + "'.", Event.class);
        }
        return this.restResponseFactory.createEventResponse(event);
    }

    @ApiOperation(value="Delete an event on a task", tags={"Tasks"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the task was found and the events are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the task doesn\u2019t have the requested event.")})
    @DeleteMapping(value={"/runtime/tasks/{taskId}/events/{eventId}"})
    public void deleteEvent(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="eventId") @PathVariable(value="eventId") String eventId, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        Event event = this.taskService.getEvent(eventId);
        if (event == null || event.getTaskId() == null || !event.getTaskId().equals(task.getId())) {
            throw new FlowableObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + event + "'.", Event.class);
        }
        this.taskService.deleteComment(eventId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

