/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.engine.HistoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.history.HistoricIdentityLinkResponse;
import org.flowable.rest.service.api.history.HistoricProcessInstanceBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Process"}, description="Manage History Process Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricProcessInstanceIdentityLinkCollectionResource
extends HistoricProcessInstanceBaseResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @ApiOperation(value="List identity links of a historic process instance", nickname="listHistoricProcessInstanceIdentityLinks", tags={"History Process"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the identity links are returned", response=HistoricIdentityLinkResponse.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the process instance could not be found..")})
    @GetMapping(value={"/history/historic-process-instances/{processInstanceId}/identitylinks"}, produces={"application/json"})
    public List<HistoricIdentityLinkResponse> getProcessIdentityLinks(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletRequest request) {
        HistoricProcessInstance processInstance = this.getHistoricProcessInstanceFromRequest(processInstanceId);
        List identityLinks = this.historyService.getHistoricIdentityLinksForProcessInstance(processInstance.getId());
        if (identityLinks != null) {
            return this.restResponseFactory.createHistoricIdentityLinkResponseList(identityLinks);
        }
        return new ArrayList<HistoricIdentityLinkResponse>();
    }
}

