/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.HistoricProcessInstanceQueryProperty;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.QueryVariable;
import org.flowable.rest.service.api.history.HistoricProcessInstanceQueryRequest;
import org.flowable.rest.service.api.history.HistoricProcessInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricProcessInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<HistoricProcessInstanceResponse> getQueryResponse(HistoricProcessInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessInstanceIds() != null && !queryRequest.getProcessInstanceIds().isEmpty()) {
            query.processInstanceIds(new HashSet<String>(queryRequest.getProcessInstanceIds()));
        }
        if (queryRequest.getProcessInstanceName() != null) {
            query.processInstanceName(queryRequest.getProcessInstanceName());
        }
        if (queryRequest.getProcessInstanceNameLike() != null) {
            query.processInstanceNameLike(queryRequest.getProcessInstanceNameLike());
        }
        if (queryRequest.getProcessInstanceNameLikeIgnoreCase() != null) {
            query.processInstanceNameLikeIgnoreCase(queryRequest.getProcessInstanceNameLikeIgnoreCase());
        }
        if (queryRequest.getProcessDefinitionKey() != null) {
            query.processDefinitionKey(queryRequest.getProcessDefinitionKey());
        }
        if (queryRequest.getProcessDefinitionKeyIn() != null) {
            query.processDefinitionKeyIn(queryRequest.getProcessDefinitionKeyIn());
        }
        if (queryRequest.getProcessDefinitionKeyNotIn() != null) {
            query.processDefinitionKeyNotIn(queryRequest.getProcessDefinitionKeyNotIn());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getProcessDefinitionName() != null) {
            query.processDefinitionName(queryRequest.getProcessDefinitionName());
        }
        if (queryRequest.getProcessDefinitionVersion() != null) {
            query.processDefinitionVersion(queryRequest.getProcessDefinitionVersion());
        }
        if (queryRequest.getProcessDefinitionCategory() != null) {
            query.processDefinitionCategory(queryRequest.getProcessDefinitionCategory());
        }
        if (queryRequest.getDeploymentId() != null) {
            query.deploymentId(queryRequest.getDeploymentId());
        }
        if (queryRequest.getDeploymentIdIn() != null) {
            query.deploymentIdIn(queryRequest.getDeploymentIdIn());
        }
        if (queryRequest.getProcessBusinessKey() != null) {
            query.processInstanceBusinessKey(queryRequest.getProcessBusinessKey());
        }
        if (queryRequest.getProcessBusinessKeyLike() != null) {
            query.processInstanceBusinessKeyLike(queryRequest.getProcessBusinessKeyLike());
        }
        if (queryRequest.getActiveActivityId() != null) {
            query.activeActivityId(queryRequest.getActiveActivityId());
        }
        if (queryRequest.getActiveActivityIds() != null) {
            query.activeActivityIds(queryRequest.getActiveActivityIds());
        }
        if (queryRequest.getInvolvedUser() != null) {
            query.involvedUser(queryRequest.getInvolvedUser());
        }
        if (queryRequest.getSuperProcessInstanceId() != null) {
            query.superProcessInstanceId(queryRequest.getSuperProcessInstanceId());
        }
        if (queryRequest.getExcludeSubprocesses() != null) {
            query.excludeSubprocesses(queryRequest.getExcludeSubprocesses().booleanValue());
        }
        if (queryRequest.getFinishedAfter() != null) {
            query.finishedAfter(queryRequest.getFinishedAfter());
        }
        if (queryRequest.getFinishedBefore() != null) {
            query.finishedBefore(queryRequest.getFinishedBefore());
        }
        if (queryRequest.getStartedAfter() != null) {
            query.startedAfter(queryRequest.getStartedAfter());
        }
        if (queryRequest.getStartedBefore() != null) {
            query.startedBefore(queryRequest.getStartedBefore());
        }
        if (queryRequest.getStartedBy() != null) {
            query.startedBy(queryRequest.getStartedBy());
        }
        if (queryRequest.getFinished() != null) {
            if (queryRequest.getFinished().booleanValue()) {
                query.finished();
            } else {
                query.unfinished();
            }
        }
        if (queryRequest.getIncludeProcessVariables() != null && queryRequest.getIncludeProcessVariables().booleanValue()) {
            query.includeProcessVariables();
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (queryRequest.getCallbackId() != null) {
            query.processInstanceCallbackId(queryRequest.getCallbackId());
        }
        if (queryRequest.getCallbackType() != null) {
            query.processInstanceCallbackType(queryRequest.getCallbackType());
        }
        if (queryRequest.getTenantId() != null) {
            query.processInstanceTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.processInstanceTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.processInstanceWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryProcessInfoWithQuery(query, queryRequest);
        }
        DataResponse responseList = PaginateListUtil.paginateList(allRequestParams, (PaginateRequest)queryRequest, (Query)query, (String)"processInstanceId", allowedSortProperties, this.restResponseFactory::createHistoricProcessInstanceResponseList);
        HashSet<String> processDefinitionIds = new HashSet<String>();
        List processInstanceList = responseList.getData();
        for (HistoricProcessInstanceResponse processInstanceResponse : processInstanceList) {
            if (processDefinitionIds.contains(processInstanceResponse.getProcessDefinitionId())) continue;
            processDefinitionIds.add(processInstanceResponse.getProcessDefinitionId());
        }
        if (processDefinitionIds.size() > 0) {
            List processDefinitionList = this.repositoryService.createProcessDefinitionQuery().processDefinitionIds(processDefinitionIds).list();
            HashMap<String, ProcessDefinition> processDefinitionMap = new HashMap<String, ProcessDefinition>();
            for (ProcessDefinition processDefinition : processDefinitionList) {
                processDefinitionMap.put(processDefinition.getId(), processDefinition);
            }
            for (HistoricProcessInstanceResponse processInstanceResponse : processInstanceList) {
                if (!processDefinitionMap.containsKey(processInstanceResponse.getProcessDefinitionId())) continue;
                ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionMap.get(processInstanceResponse.getProcessDefinitionId());
                processInstanceResponse.setProcessDefinitionName(processDefinition.getName());
                processInstanceResponse.setProcessDefinitionDescription(processDefinition.getDescription());
            }
        }
        return responseList;
    }

    protected HistoricProcessInstance getHistoricProcessInstanceFromRequest(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", HistoricProcessInstance.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryProcessInfoById(processInstance);
        }
        return processInstance;
    }

    protected void addVariables(HistoricProcessInstanceQuery processInstanceQuery, List<QueryVariable> variables) {
        block11: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        processInstanceQuery.variableValueEquals(actualValue);
                        continue block11;
                    }
                    processInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    processInstanceQuery.variableValueNotEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueLike(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported for like, but was: " + actualValue.getClass().getName());
                }
                case LIKE_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueLikeIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported for like, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    processInstanceQuery.variableValueGreaterThan(variable.getName(), actualValue);
                    continue block11;
                }
                case GREATER_THAN_OR_EQUALS: {
                    processInstanceQuery.variableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN: {
                    processInstanceQuery.variableValueLessThan(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN_OR_EQUALS: {
                    processInstanceQuery.variableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    static {
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricProcessInstanceQueryProperty.PROCESS_INSTANCE_ID_);
        allowedSortProperties.put("processDefinitionId", (QueryProperty)HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("businessKey", (QueryProperty)HistoricProcessInstanceQueryProperty.BUSINESS_KEY);
        allowedSortProperties.put("startTime", (QueryProperty)HistoricProcessInstanceQueryProperty.START_TIME);
        allowedSortProperties.put("endTime", (QueryProperty)HistoricProcessInstanceQueryProperty.END_TIME);
        allowedSortProperties.put("duration", (QueryProperty)HistoricProcessInstanceQueryProperty.DURATION);
        allowedSortProperties.put("tenantId", (QueryProperty)HistoricProcessInstanceQueryProperty.TENANT_ID);
    }
}

