/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.engine.ProcessMigrationService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationDocumentConverter;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.rest.service.api.FormHandlerRestApiInterceptor;
import org.flowable.rest.service.api.FormModelResponse;
import org.flowable.rest.service.api.repository.BaseProcessDefinitionResource;
import org.flowable.rest.service.api.repository.ProcessDefinitionActionRequest;
import org.flowable.rest.service.api.repository.ProcessDefinitionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionResource
extends BaseProcessDefinitionResource {
    @Autowired
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    @Autowired
    protected ProcessMigrationService processMigrationService;
    @Autowired(required=false)
    protected FormRepositoryService formRepositoryService;
    @Autowired(required=false)
    protected FormHandlerRestApiInterceptor formHandlerRestApiInterceptor;

    @ApiOperation(value="Get a process definition", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the process-definitions are returned"), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @GetMapping(value={"/repository/process-definitions/{processDefinitionId}"}, produces={"application/json"})
    public ProcessDefinitionResponse getProcessDefinition(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        return this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
    }

    @ApiOperation(value="Execute actions for a process definition", tags={"Process Definitions"}, notes="Execute actions for a process definition (Update category, Suspend or Activate)")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates action has been executed for the specified process. (category altered, activate or suspend)"), @ApiResponse(code=400, message="Indicates no category was defined in the request body."), @ApiResponse(code=404, message="Indicates the requested process definition was not found."), @ApiResponse(code=409, message="Indicates the requested process definition is already suspended or active.")})
    @PutMapping(value={"/repository/process-definitions/{processDefinitionId}"}, produces={"application/json"})
    public ProcessDefinitionResponse executeProcessDefinitionAction(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, @ApiParam(required=true) @RequestBody ProcessDefinitionActionRequest actionRequest, HttpServletRequest request) {
        if (actionRequest == null) {
            throw new FlowableIllegalArgumentException("No action found in request body.");
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        if (actionRequest.getCategory() != null) {
            this.repositoryService.setProcessDefinitionCategory(processDefinition.getId(), actionRequest.getCategory());
            ProcessDefinitionResponse response = this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
            response.setCategory(actionRequest.getCategory());
            return response;
        }
        if (actionRequest.getAction() != null) {
            if ("suspend".equals(actionRequest.getAction())) {
                return this.suspendProcessDefinition(processDefinition, actionRequest.isIncludeProcessInstances(), actionRequest.getDate());
            }
            if ("activate".equals(actionRequest.getAction())) {
                return this.activateProcessDefinition(processDefinition, actionRequest.isIncludeProcessInstances(), actionRequest.getDate());
            }
        }
        throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }

    @ApiOperation(value="Get a process definition start form", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the process definition form is returned"), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @GetMapping(value={"/repository/process-definitions/{processDefinitionId}/start-form"}, produces={"application/json"})
    public String getProcessDefinitionStartForm(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletRequest request) {
        if (this.formRepositoryService == null) {
            return null;
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        FormInfo formInfo = this.getStartForm(processDefinition);
        if (this.formHandlerRestApiInterceptor != null) {
            return this.formHandlerRestApiInterceptor.convertStartFormInfo(formInfo, processDefinition);
        }
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        return this.restResponseFactory.getFormModelString(new FormModelResponse(formInfo, formModel));
    }

    @ApiOperation(value="Migrate all instances of process definition", tags={"Process Definitions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates process instances were found and migration was executed."), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @PostMapping(value={"/repository/process-definitions/{processDefinitionId}/migrate"}, produces={"application/json"})
    public void migrateInstancesOfProcessDefinition(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, @RequestBody String migrationDocumentJson, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateInstancesOfProcessDefinition(processDefinition, migrationDocumentJson);
        }
        ProcessInstanceMigrationDocument migrationDocument = ProcessInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.processMigrationService.migrateProcessInstancesOfProcessDefinition(processDefinitionId, migrationDocument);
    }

    @ApiOperation(value="Batch migrate all instances of process definition", tags={"Process Definitions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates process instances were found and batch migration was started."), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @PostMapping(value={"/repository/process-definitions/{processDefinitionId}/batch-migrate"}, produces={"application/json"})
    public void batchMigrateInstancesOfProcessDefinition(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, @RequestBody String migrationDocumentJson, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateInstancesOfProcessDefinition(processDefinition, migrationDocumentJson);
        }
        ProcessInstanceMigrationDocument migrationDocument = ProcessInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.processMigrationService.batchMigrateProcessInstancesOfProcessDefinition(processDefinitionId, migrationDocument);
    }

    protected FormInfo getStartForm(ProcessDefinition processDefinition) {
        StartEvent startEvent;
        FormInfo formInfo = null;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Process process = bpmnModel.getProcessById(processDefinition.getKey());
        FlowElement startElement = process.getInitialFlowElement();
        if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey())) {
            if (startEvent.isSameDeployment()) {
                Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).singleResult();
                formInfo = this.formRepositoryService.getFormModelByKeyAndParentDeploymentId(startEvent.getFormKey(), deployment.getParentDeploymentId(), processDefinition.getTenantId(), this.processEngineConfiguration.isFallbackToDefaultTenant());
            } else {
                formInfo = this.formRepositoryService.getFormModelByKey(startEvent.getFormKey(), processDefinition.getTenantId(), this.processEngineConfiguration.isFallbackToDefaultTenant());
            }
        }
        if (formInfo == null) {
            throw new FlowableObjectNotFoundException("Process definition does not have a form defined: " + processDefinition.getId());
        }
        return formInfo;
    }

    protected ProcessDefinitionResponse activateProcessDefinition(ProcessDefinition processDefinition, boolean suspendInstances, Date date) {
        if (!this.repositoryService.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableConflictException("Process definition with id '" + processDefinition.getId() + " ' is already active");
        }
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), suspendInstances, date);
        ProcessDefinitionResponse response = this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
        response.setSuspended(false);
        return response;
    }

    protected ProcessDefinitionResponse suspendProcessDefinition(ProcessDefinition processDefinition, boolean suspendInstances, Date date) {
        if (this.repositoryService.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableConflictException("Process definition with id '" + processDefinition.getId() + " ' is already suspended");
        }
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), suspendInstances, date);
        ProcessDefinitionResponse response = this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
        response.setSuspended(true);
        return response;
    }
}

