/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.ProcessMigrationService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.impl.dynamic.DynamicEmbeddedSubProcessBuilder;
import org.flowable.engine.impl.dynamic.DynamicUserTaskBuilder;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationDocumentConverter;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.flowable.rest.service.api.runtime.process.ExecutionChangeActivityStateRequest;
import org.flowable.rest.service.api.runtime.process.InjectActivityRequest;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceUpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Instances"}, description="Manage Process Instances", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceResource
extends BaseProcessInstanceResource {
    @Autowired
    protected DynamicBpmnService dynamicBpmnService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ProcessMigrationService migrationService;

    @ApiOperation(value="Get a process instance", tags={"Process Instances"}, nickname="getProcessInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and returned."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @GetMapping(value={"/runtime/process-instances/{processInstanceId}"}, produces={"application/json"})
    public ProcessInstanceResponse getProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletRequest request) {
        ProcessInstanceResponse processInstanceResponse = this.restResponseFactory.createProcessInstanceResponse(this.getProcessInstanceFromRequest(processInstanceId));
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstanceResponse.getProcessDefinitionId()).singleResult();
        if (processDefinition != null) {
            processInstanceResponse.setProcessDefinitionName(processDefinition.getName());
            processInstanceResponse.setProcessDefinitionDescription(processDefinition.getDescription());
        }
        return processInstanceResponse;
    }

    @ApiOperation(value="Delete a process instance", tags={"Process Instances"}, nickname="deleteProcessInstance")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the process instance was found and deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @DeleteMapping(value={"/runtime/process-instances/{processInstanceId}"})
    public void deleteProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestParam(value="deleteReason", required=false) String deleteReason, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteProcessInstance(processInstance);
        }
        this.runtimeService.deleteProcessInstance(processInstance.getId(), deleteReason);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ApiOperation(value="Update process instance properties or execute an action on a process instance (body needs to contain an 'action' property for the latter).", tags={"Process Instances"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and the update/action was executed."), @ApiResponse(code=400, message="Indicates a invalid parameters are supplied."), @ApiResponse(code=409, message="Indicates the requested process instance change cannot be executed since the process-instance is in a wrong status which doesn't accept the change"), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @PutMapping(value={"/runtime/process-instances/{processInstanceId}"}, produces={"application/json"})
    public ProcessInstanceResponse updateProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestBody ProcessInstanceUpdateRequest updateRequest, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.updateProcessInstance(processInstance, updateRequest);
        }
        if (StringUtils.isNotEmpty((CharSequence)updateRequest.getAction())) {
            if ("activate".equals(updateRequest.getAction())) {
                return this.activateProcessInstance(processInstance);
            }
            if ("suspend".equals(updateRequest.getAction())) {
                return this.suspendProcessInstance(processInstance);
            }
            throw new FlowableIllegalArgumentException("Invalid action: '" + updateRequest.getAction() + "'.");
        }
        if (StringUtils.isNotEmpty((CharSequence)updateRequest.getName())) {
            this.runtimeService.setProcessInstanceName(processInstanceId, updateRequest.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)updateRequest.getBusinessKey())) {
            this.runtimeService.updateBusinessKey(processInstanceId, updateRequest.getBusinessKey());
        }
        if ((processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()) == null) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        return this.restResponseFactory.createProcessInstanceResponse(processInstance);
    }

    @ApiOperation(value="Change the state a process instance", tags={"Process Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and change state activity was executed."), @ApiResponse(code=409, message="Indicates the requested process instance action cannot be executed since the process-instance is already activated/suspended."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @PostMapping(value={"/runtime/process-instances/{processInstanceId}/change-state"}, produces={"application/json"})
    public void changeActivityState(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestBody ExecutionChangeActivityStateRequest activityStateRequest, HttpServletRequest request) {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.changeActivityState(activityStateRequest);
        }
        if (activityStateRequest.getCancelActivityIds() != null && activityStateRequest.getCancelActivityIds().size() == 1) {
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId).moveSingleActivityIdToActivityIds(activityStateRequest.getCancelActivityIds().get(0), activityStateRequest.getStartActivityIds()).changeState();
        } else if (activityStateRequest.getStartActivityIds() != null && activityStateRequest.getStartActivityIds().size() == 1) {
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId).moveActivityIdsToSingleActivityId(activityStateRequest.getCancelActivityIds(), activityStateRequest.getStartActivityIds().get(0)).changeState();
        }
    }

    @ApiOperation(value="Evaluate the conditions of a process instance", tags={"Process Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and the evaluation of the conditions was executed."), @ApiResponse(code=409, message="Indicates the requested process instance action cannot be executed since the process-instance is already activated/suspended."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @PostMapping(value={"/runtime/process-instances/{processInstanceId}/evaluate-conditions"}, produces={"application/json"})
    public void evaluateConditions(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        this.runtimeService.evaluateConditionalEvents(processInstance.getId());
    }

    @ApiOperation(value="Migrate process instance", tags={"Process Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and migration was executed."), @ApiResponse(code=409, message="Indicates the requested process instance action cannot be executed since the process-instance is already activated/suspended."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @PostMapping(value={"/runtime/process-instances/{processInstanceId}/migrate"}, produces={"application/json"})
    public void migrateProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestBody String migrationDocumentJson, HttpServletRequest request) {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateProcessInstance(processInstanceId, migrationDocumentJson);
        }
        ProcessInstanceMigrationDocument migrationDocument = ProcessInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.migrationService.migrateProcessInstance(processInstanceId, migrationDocument);
    }

    @ApiOperation(value="Inject activity in a process instance", tags={"Process Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was updated and the activity injection was executed."), @ApiResponse(code=409, message="Indicates the requested process instance action cannot be executed since the process-instance is already activated/suspended."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @PostMapping(value={"/runtime/process-instances/{processInstanceId}/inject"}, produces={"application/json"})
    public void injectActivityInProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestBody InjectActivityRequest injectActivityRequest, HttpServletRequest request) {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.injectActivity(injectActivityRequest);
        }
        if ("task".equalsIgnoreCase(injectActivityRequest.getInjectionType())) {
            DynamicUserTaskBuilder taskBuilder = new DynamicUserTaskBuilder();
            taskBuilder.id(injectActivityRequest.getId()).name(injectActivityRequest.getName()).assignee(injectActivityRequest.getAssignee());
            if (injectActivityRequest.getTaskId() != null) {
                this.dynamicBpmnService.injectParallelUserTask(injectActivityRequest.getTaskId(), taskBuilder);
            } else {
                this.dynamicBpmnService.injectUserTaskInProcessInstance(processInstanceId, taskBuilder);
            }
        } else if ("subprocess".equalsIgnoreCase(injectActivityRequest.getInjectionType())) {
            if (StringUtils.isEmpty((CharSequence)injectActivityRequest.getProcessDefinitionId())) {
                throw new FlowableIllegalArgumentException("processDefinitionId is required");
            }
            DynamicEmbeddedSubProcessBuilder subProcessBuilder = new DynamicEmbeddedSubProcessBuilder();
            subProcessBuilder.id(injectActivityRequest.getId()).processDefinitionId(injectActivityRequest.getProcessDefinitionId());
            if (injectActivityRequest.getTaskId() != null) {
                this.dynamicBpmnService.injectParallelEmbeddedSubProcess(injectActivityRequest.getTaskId(), subProcessBuilder);
            } else {
                this.dynamicBpmnService.injectEmbeddedSubProcessInProcessInstance(processInstanceId, subProcessBuilder);
            }
        } else {
            throw new FlowableIllegalArgumentException("injection type is not supported " + injectActivityRequest.getInjectionType());
        }
    }

    protected ProcessInstanceResponse activateProcessInstance(ProcessInstance processInstance) {
        if (!processInstance.isSuspended()) {
            throw new FlowableConflictException("Process instance with id '" + processInstance.getId() + "' is already active.");
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = this.restResponseFactory.createProcessInstanceResponse(processInstance);
        response.setSuspended(false);
        return response;
    }

    protected ProcessInstanceResponse suspendProcessInstance(ProcessInstance processInstance) {
        if (processInstance.isSuspended()) {
            throw new FlowableConflictException("Process instance with id '" + processInstance.getId() + "' is already suspended.");
        }
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = this.restResponseFactory.createProcessInstanceResponse(processInstance);
        response.setSuspended(true);
        return response;
    }
}

