/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.common.rest.util.RestUrlBuilder;
import org.flowable.common.rest.variable.BooleanRestVariableConverter;
import org.flowable.common.rest.variable.DateRestVariableConverter;
import org.flowable.common.rest.variable.DoubleRestVariableConverter;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.InstantRestVariableConverter;
import org.flowable.common.rest.variable.IntegerRestVariableConverter;
import org.flowable.common.rest.variable.JsonObjectRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateTimeRestVariableConverter;
import org.flowable.common.rest.variable.LongRestVariableConverter;
import org.flowable.common.rest.variable.RestVariableConverter;
import org.flowable.common.rest.variable.ShortRestVariableConverter;
import org.flowable.common.rest.variable.StringRestVariableConverter;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.engine.form.FormData;
import org.flowable.engine.form.FormProperty;
import org.flowable.engine.form.StartFormData;
import org.flowable.engine.form.TaskFormData;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricDetail;
import org.flowable.engine.history.HistoricFormProperty;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricVariableUpdate;
import org.flowable.engine.impl.bpmn.deployer.ResourceNameUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.task.Attachment;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Event;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.form.api.FormDefinition;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.identitylink.api.history.HistoricIdentityLink;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.rest.service.api.FormModelResponse;
import org.flowable.rest.service.api.RestUrls;
import org.flowable.rest.service.api.engine.AttachmentResponse;
import org.flowable.rest.service.api.engine.CommentResponse;
import org.flowable.rest.service.api.engine.EventResponse;
import org.flowable.rest.service.api.engine.RestIdentityLink;
import org.flowable.rest.service.api.engine.variable.QueryVariable;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.rest.service.api.form.FormDataResponse;
import org.flowable.rest.service.api.form.RestEnumFormProperty;
import org.flowable.rest.service.api.form.RestFormProperty;
import org.flowable.rest.service.api.history.HistoricActivityInstanceResponse;
import org.flowable.rest.service.api.history.HistoricDetailResponse;
import org.flowable.rest.service.api.history.HistoricIdentityLinkResponse;
import org.flowable.rest.service.api.history.HistoricProcessInstanceResponse;
import org.flowable.rest.service.api.history.HistoricTaskInstanceResponse;
import org.flowable.rest.service.api.history.HistoricTaskLogEntryResponse;
import org.flowable.rest.service.api.history.HistoricVariableInstanceResponse;
import org.flowable.rest.service.api.identity.GroupResponse;
import org.flowable.rest.service.api.identity.MembershipResponse;
import org.flowable.rest.service.api.identity.UserInfoResponse;
import org.flowable.rest.service.api.identity.UserResponse;
import org.flowable.rest.service.api.management.BatchPartResponse;
import org.flowable.rest.service.api.management.BatchResponse;
import org.flowable.rest.service.api.management.HistoryJobResponse;
import org.flowable.rest.service.api.management.JobResponse;
import org.flowable.rest.service.api.management.TableResponse;
import org.flowable.rest.service.api.repository.DecisionResponse;
import org.flowable.rest.service.api.repository.DeploymentResourceResponse;
import org.flowable.rest.service.api.repository.DeploymentResponse;
import org.flowable.rest.service.api.repository.FormDefinitionResponse;
import org.flowable.rest.service.api.repository.ModelResponse;
import org.flowable.rest.service.api.repository.ProcessDefinitionResponse;
import org.flowable.rest.service.api.runtime.VariableInstanceResponse;
import org.flowable.rest.service.api.runtime.process.ActivityInstanceResponse;
import org.flowable.rest.service.api.runtime.process.EventSubscriptionResponse;
import org.flowable.rest.service.api.runtime.process.ExecutionResponse;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.flowable.rest.service.api.runtime.task.TaskResponse;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntry;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class RestResponseFactory {
    public static final int VARIABLE_TASK = 1;
    public static final int VARIABLE_EXECUTION = 2;
    public static final int VARIABLE_PROCESS = 3;
    public static final int VARIABLE_VARINSTANCE = 4;
    public static final int VARIABLE_HISTORY_TASK = 5;
    public static final int VARIABLE_HISTORY_PROCESS = 6;
    public static final int VARIABLE_HISTORY_VARINSTANCE = 7;
    public static final int VARIABLE_HISTORY_DETAIL = 8;
    public static final String BYTE_ARRAY_VARIABLE_TYPE = "binary";
    public static final String SERIALIZABLE_VARIABLE_TYPE = "serializable";
    protected ObjectMapper objectMapper;
    protected List<RestVariableConverter> variableConverters = new ArrayList<RestVariableConverter>();

    public RestResponseFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.initializeVariableConverters();
    }

    public List<TaskResponse> createTaskResponseList(List<Task> tasks) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<TaskResponse> responseList = new ArrayList<TaskResponse>(tasks.size());
        for (Task instance : tasks) {
            responseList.add(this.createTaskResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public TaskResponse createTaskResponse(Task task) {
        return this.createTaskResponse(task, this.createUrlBuilder());
    }

    public TaskResponse createTaskResponse(Task task, RestUrlBuilder urlBuilder) {
        Map variableMap;
        TaskResponse response = new TaskResponse(task);
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_TASK, new Object[]{task.getId()}));
        if (response.getParentTaskId() != null) {
            response.setParentTaskUrl(urlBuilder.buildUrl(RestUrls.URL_TASK, new Object[]{response.getParentTaskId()}));
        }
        if (response.getProcessDefinitionId() != null) {
            response.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{response.getProcessDefinitionId()}));
        }
        if (response.getExecutionId() != null) {
            response.setExecutionUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION, new Object[]{response.getExecutionId()}));
        }
        if (response.getProcessInstanceId() != null) {
            response.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{response.getProcessInstanceId()}));
        }
        if (task.getProcessVariables() != null) {
            variableMap = task.getProcessVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, task.getId(), 1, false, urlBuilder));
            }
        }
        if (task.getTaskLocalVariables() != null) {
            variableMap = task.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, task.getId(), 1, false, urlBuilder));
            }
        }
        return response;
    }

    public List<DeploymentResponse> createDeploymentResponseList(List<Deployment> deployments) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DeploymentResponse> responseList = new ArrayList<DeploymentResponse>(deployments.size());
        for (Deployment instance : deployments) {
            responseList.add(this.createDeploymentResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public DeploymentResponse createDeploymentResponse(Deployment deployment) {
        return this.createDeploymentResponse(deployment, this.createUrlBuilder());
    }

    public DeploymentResponse createDeploymentResponse(Deployment deployment, RestUrlBuilder urlBuilder) {
        return new DeploymentResponse(deployment, urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT, new Object[]{deployment.getId()}));
    }

    public List<DeploymentResourceResponse> createDeploymentResourceResponseList(String deploymentId, List<String> resourceList, ContentTypeResolver contentTypeResolver) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DeploymentResourceResponse> responseList = new ArrayList<DeploymentResourceResponse>(resourceList.size());
        for (String resourceId : resourceList) {
            responseList.add(this.createDeploymentResourceResponse(deploymentId, resourceId, contentTypeResolver.resolveContentType(resourceId), urlBuilder));
        }
        return responseList;
    }

    public DeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType) {
        return this.createDeploymentResourceResponse(deploymentId, resourceId, contentType, this.createUrlBuilder());
    }

    public DeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType, RestUrlBuilder urlBuilder) {
        String resourceUrl = urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{deploymentId, resourceId});
        String resourceContentUrl = urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT_RESOURCE_CONTENT, new Object[]{deploymentId, resourceId});
        String type = "resource";
        for (String suffix : ResourceNameUtil.BPMN_RESOURCE_SUFFIXES) {
            if (!resourceId.endsWith(suffix)) continue;
            type = "processDefinition";
            break;
        }
        return new DeploymentResourceResponse(resourceId, resourceUrl, resourceContentUrl, contentType, type);
    }

    public List<ProcessDefinitionResponse> createProcessDefinitionResponseList(List<ProcessDefinition> processDefinitions) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ProcessDefinitionResponse> responseList = new ArrayList<ProcessDefinitionResponse>(processDefinitions.size());
        for (ProcessDefinition instance : processDefinitions) {
            responseList.add(this.createProcessDefinitionResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public ProcessDefinitionResponse createProcessDefinitionResponse(ProcessDefinition processDefinition) {
        return this.createProcessDefinitionResponse(processDefinition, this.createUrlBuilder());
    }

    public ProcessDefinitionResponse createProcessDefinitionResponse(ProcessDefinition processDefinition, RestUrlBuilder urlBuilder) {
        ProcessDefinitionResponse response = new ProcessDefinitionResponse();
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processDefinition.getId()}));
        response.setId(processDefinition.getId());
        response.setKey(processDefinition.getKey());
        response.setVersion(processDefinition.getVersion());
        response.setCategory(processDefinition.getCategory());
        response.setName(processDefinition.getName());
        response.setDescription(processDefinition.getDescription());
        response.setSuspended(processDefinition.isSuspended());
        response.setStartFormDefined(processDefinition.hasStartFormKey());
        response.setGraphicalNotationDefined(processDefinition.hasGraphicalNotation());
        response.setTenantId(processDefinition.getTenantId());
        response.setDeploymentId(processDefinition.getDeploymentId());
        response.setDeploymentUrl(urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT, new Object[]{processDefinition.getDeploymentId()}));
        response.setResource(urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{processDefinition.getDeploymentId(), processDefinition.getResourceName()}));
        if (processDefinition.getDiagramResourceName() != null) {
            response.setDiagramResource(urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{processDefinition.getDeploymentId(), processDefinition.getDiagramResourceName()}));
        }
        return response;
    }

    public String getFormModelString(FormModelResponse formModelResponse) {
        try {
            return this.objectMapper.writeValueAsString((Object)formModelResponse);
        }
        catch (Exception e) {
            throw new FlowableException("Error writing form model response", (Throwable)e);
        }
    }

    public List<RestVariable> createRestVariables(Map<String, Object> variables, String id, int variableType, RestVariable.RestVariableScope scope) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<RestVariable> result = new ArrayList<RestVariable>(variables.size());
        for (Map.Entry<String, Object> pair : variables.entrySet()) {
            result.add(this.createRestVariable(pair.getKey(), pair.getValue(), scope, id, variableType, false, urlBuilder));
        }
        return result;
    }

    public RestVariable createRestVariable(String name, Object value, RestVariable.RestVariableScope scope, String id, int variableType, boolean includeBinaryValue) {
        return this.createRestVariable(name, value, scope, id, variableType, includeBinaryValue, this.createUrlBuilder());
    }

    public RestVariable createRestVariable(String name, Object value, RestVariable.RestVariableScope scope, String id, int variableType, boolean includeBinaryValue, RestUrlBuilder urlBuilder) {
        RestVariableConverter converter = null;
        RestVariable restVar = new RestVariable();
        restVar.setVariableScope(scope);
        restVar.setName(name);
        if (value != null) {
            for (RestVariableConverter c : this.variableConverters) {
                if (!c.getVariableType().isAssignableFrom(value.getClass())) continue;
                converter = c;
                break;
            }
            if (converter != null) {
                converter.convertVariableValue(value, (EngineRestVariable)restVar);
                restVar.setType(converter.getRestTypeName());
            } else {
                if (value instanceof Byte[] || value instanceof byte[]) {
                    restVar.setType(BYTE_ARRAY_VARIABLE_TYPE);
                } else {
                    restVar.setType(SERIALIZABLE_VARIABLE_TYPE);
                }
                if (includeBinaryValue) {
                    restVar.setValue(value);
                }
                if (variableType == 1) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_TASK_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 2) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 3) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 4) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_VARIABLE_INSTANCE_DATA, new Object[]{id}));
                } else if (variableType == 5) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 6) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 7) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_VARIABLE_INSTANCE_DATA, new Object[]{id}));
                } else if (variableType == 8) {
                    restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_DETAIL_VARIABLE_DATA, new Object[]{id}));
                }
            }
        }
        return restVar;
    }

    public RestVariable createBinaryRestVariable(String name, RestVariable.RestVariableScope scope, String type, String taskId, String executionId, String processInstanceId) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        RestVariable restVar = new RestVariable();
        restVar.setVariableScope(scope);
        restVar.setName(name);
        restVar.setType(type);
        if (taskId != null) {
            restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_TASK_VARIABLE_DATA, new Object[]{taskId, name}));
        }
        if (executionId != null) {
            restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION_VARIABLE_DATA, new Object[]{executionId, name}));
        }
        if (processInstanceId != null) {
            restVar.setValueUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE_VARIABLE_DATA, new Object[]{processInstanceId, name}));
        }
        return restVar;
    }

    public Object getVariableValue(RestVariable restVariable) {
        Object value = null;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new FlowableIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            value = converter.getVariableValue((EngineRestVariable)restVariable);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    public Object getVariableValue(QueryVariable restVariable) {
        Object value = null;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new FlowableIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            RestVariable temp = new RestVariable();
            temp.setValue(restVariable.getValue());
            temp.setType(restVariable.getType());
            temp.setName(restVariable.getName());
            value = converter.getVariableValue((EngineRestVariable)temp);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    public List<RestIdentityLink> createRestIdentityLinks(List<IdentityLink> links) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<RestIdentityLink> responseList = new ArrayList<RestIdentityLink>(links.size());
        for (IdentityLink instance : links) {
            responseList.add(this.createRestIdentityLink(instance, urlBuilder));
        }
        return responseList;
    }

    public RestIdentityLink createRestIdentityLink(IdentityLink link) {
        return this.createRestIdentityLink(link, this.createUrlBuilder());
    }

    public RestIdentityLink createRestIdentityLink(IdentityLink link, RestUrlBuilder urlBuilder) {
        return this.createRestIdentityLink(link.getType(), link.getUserId(), link.getGroupId(), link.getTaskId(), link.getProcessDefinitionId(), link.getProcessInstanceId(), urlBuilder);
    }

    public RestIdentityLink createRestIdentityLink(String type, String userId, String groupId, String taskId, String processDefinitionId, String processInstanceId) {
        return this.createRestIdentityLink(type, userId, groupId, taskId, processDefinitionId, processInstanceId, this.createUrlBuilder());
    }

    public RestIdentityLink createRestIdentityLink(String type, String userId, String groupId, String taskId, String processDefinitionId, String processInstanceId, RestUrlBuilder urlBuilder) {
        RestIdentityLink result = new RestIdentityLink();
        result.setUser(userId);
        result.setGroup(groupId);
        result.setType(type);
        String family = null;
        family = userId != null ? "users" : "groups";
        if (processDefinitionId != null) {
            result.setUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION_IDENTITYLINK, new Object[]{processDefinitionId, family, userId != null ? userId : groupId}));
        } else if (taskId != null) {
            result.setUrl(urlBuilder.buildUrl(RestUrls.URL_TASK_IDENTITYLINK, new Object[]{taskId, family, userId != null ? userId : groupId, type}));
        } else {
            result.setUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE_IDENTITYLINK, new Object[]{processInstanceId, userId != null ? userId : groupId, type}));
        }
        return result;
    }

    public List<CommentResponse> createRestCommentList(List<Comment> comments) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<CommentResponse> responseList = new ArrayList<CommentResponse>(comments.size());
        for (Comment instance : comments) {
            responseList.add(this.createRestComment(instance, urlBuilder));
        }
        return responseList;
    }

    public CommentResponse createRestComment(Comment comment) {
        return this.createRestComment(comment, this.createUrlBuilder());
    }

    public CommentResponse createRestComment(Comment comment, RestUrlBuilder urlBuilder) {
        CommentResponse result = new CommentResponse();
        result.setAuthor(comment.getUserId());
        result.setMessage(comment.getFullMessage());
        result.setId(comment.getId());
        result.setTime(comment.getTime());
        result.setTaskId(comment.getTaskId());
        result.setProcessInstanceId(comment.getProcessInstanceId());
        if (comment.getTaskId() != null) {
            result.setTaskUrl(urlBuilder.buildUrl(RestUrls.URL_TASK_COMMENT, new Object[]{comment.getTaskId(), comment.getId()}));
        }
        if (comment.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE_COMMENT, new Object[]{comment.getProcessInstanceId(), comment.getId()}));
        }
        return result;
    }

    public List<EventResponse> createEventResponseList(List<Event> events) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<EventResponse> responseList = new ArrayList<EventResponse>(events.size());
        for (Event instance : events) {
            responseList.add(this.createEventResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public EventResponse createEventResponse(Event event) {
        return this.createEventResponse(event, this.createUrlBuilder());
    }

    public EventResponse createEventResponse(Event event, RestUrlBuilder urlBuilder) {
        EventResponse result = new EventResponse();
        result.setAction(event.getAction());
        result.setId(event.getId());
        result.setMessage(event.getMessageParts());
        result.setTime(event.getTime());
        result.setUserId(event.getUserId());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_TASK_EVENT, new Object[]{event.getTaskId(), event.getId()}));
        result.setTaskUrl(urlBuilder.buildUrl(RestUrls.URL_TASK, new Object[]{event.getTaskId()}));
        if (event.getProcessInstanceId() != null) {
            result.setTaskUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{event.getProcessInstanceId()}));
        }
        return result;
    }

    public AttachmentResponse createAttachmentResponse(Attachment attachment) {
        return this.createAttachmentResponse(attachment, this.createUrlBuilder());
    }

    public AttachmentResponse createAttachmentResponse(Attachment attachment, RestUrlBuilder urlBuilder) {
        AttachmentResponse result = new AttachmentResponse();
        result.setId(attachment.getId());
        result.setName(attachment.getName());
        result.setDescription(attachment.getDescription());
        result.setTime(attachment.getTime());
        result.setType(attachment.getType());
        result.setUserId(attachment.getUserId());
        if (attachment.getUrl() == null && attachment.getTaskId() != null) {
            result.setContentUrl(urlBuilder.buildUrl(RestUrls.URL_TASK_ATTACHMENT_DATA, new Object[]{attachment.getTaskId(), attachment.getId()}));
        } else {
            result.setExternalUrl(attachment.getUrl());
        }
        if (attachment.getTaskId() != null) {
            result.setUrl(urlBuilder.buildUrl(RestUrls.URL_TASK_ATTACHMENT, new Object[]{attachment.getTaskId(), attachment.getId()}));
            result.setTaskUrl(urlBuilder.buildUrl(RestUrls.URL_TASK, new Object[]{attachment.getTaskId()}));
        }
        if (attachment.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{attachment.getProcessInstanceId()}));
        }
        return result;
    }

    public List<ProcessInstanceResponse> createProcessInstanceResponseList(List<ProcessInstance> processInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ProcessInstanceResponse> responseList = new ArrayList<ProcessInstanceResponse>(processInstances.size());
        for (ProcessInstance instance : processInstances) {
            responseList.add(this.createProcessInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public ProcessInstanceResponse createProcessInstanceResponse(ProcessInstance processInstance) {
        return this.createProcessInstanceResponse(processInstance, this.createUrlBuilder());
    }

    public ProcessInstanceResponse createProcessInstanceResponse(ProcessInstance processInstance, RestUrlBuilder urlBuilder) {
        ProcessInstanceResponse result = this.internalCreateProcessInstanceResponse(processInstance, urlBuilder);
        if (processInstance.getProcessVariables() != null) {
            Map variableMap = processInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 3, false, urlBuilder));
            }
        }
        return result;
    }

    public ProcessInstanceResponse createProcessInstanceResponse(ProcessInstance processInstance, boolean returnVariables, Map<String, Object> runtimeVariableMap, List<HistoricVariableInstance> historicVariableList) {
        ProcessInstanceResponse result;
        block3: {
            RestUrlBuilder urlBuilder;
            block4: {
                urlBuilder = this.createUrlBuilder();
                result = this.internalCreateProcessInstanceResponse(processInstance, urlBuilder);
                if (!returnVariables) break block3;
                if (!processInstance.isEnded()) break block4;
                if (historicVariableList == null) break block3;
                for (HistoricVariableInstance historicVariable : historicVariableList) {
                    result.addVariable(this.createRestVariable(historicVariable.getVariableName(), historicVariable.getValue(), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 3, false, urlBuilder));
                }
                break block3;
            }
            if (runtimeVariableMap != null) {
                for (String name : runtimeVariableMap.keySet()) {
                    result.addVariable(this.createRestVariable(name, runtimeVariableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 3, false, urlBuilder));
                }
            }
        }
        return result;
    }

    protected ProcessInstanceResponse internalCreateProcessInstanceResponse(ProcessInstance processInstance, RestUrlBuilder urlBuilder) {
        ProcessInstanceResponse result = new ProcessInstanceResponse();
        result.setActivityId(processInstance.getActivityId());
        result.setStartUserId(processInstance.getStartUserId());
        result.setStartTime(processInstance.getStartTime());
        result.setBusinessKey(processInstance.getBusinessKey());
        result.setBusinessStatus(processInstance.getBusinessStatus());
        result.setId(processInstance.getId());
        result.setName(processInstance.getName());
        result.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processInstance.getProcessDefinitionId()}));
        result.setEnded(processInstance.isEnded());
        result.setSuspended(processInstance.isSuspended());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{processInstance.getId()}));
        result.setCallbackId(processInstance.getCallbackId());
        result.setCallbackType(processInstance.getCallbackType());
        result.setReferenceId(processInstance.getReferenceId());
        result.setReferenceType(processInstance.getReferenceType());
        result.setPropagatedStageInstanceId(processInstance.getPropagatedStageInstanceId());
        result.setTenantId(processInstance.getTenantId());
        if (processInstance.isEnded()) {
            result.setCompleted(true);
        } else {
            result.setCompleted(false);
        }
        return result;
    }

    public List<ExecutionResponse> createExecutionResponseList(List<Execution> executions) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ExecutionResponse> responseList = new ArrayList<ExecutionResponse>(executions.size());
        for (Execution instance : executions) {
            responseList.add(this.createExecutionResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public ExecutionResponse createExecutionResponse(Execution execution) {
        return this.createExecutionResponse(execution, this.createUrlBuilder());
    }

    public ExecutionResponse createExecutionResponse(Execution execution, RestUrlBuilder urlBuilder) {
        ExecutionResponse result = new ExecutionResponse();
        result.setActivityId(execution.getActivityId());
        result.setId(execution.getId());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION, new Object[]{execution.getId()}));
        result.setSuspended(execution.isSuspended());
        result.setTenantId(execution.getTenantId());
        result.setParentId(execution.getParentId());
        if (execution.getParentId() != null) {
            result.setParentUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION, new Object[]{execution.getParentId()}));
        }
        result.setSuperExecutionId(execution.getSuperExecutionId());
        if (execution.getSuperExecutionId() != null) {
            result.setSuperExecutionUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION, new Object[]{execution.getSuperExecutionId()}));
        }
        result.setProcessInstanceId(execution.getProcessInstanceId());
        if (execution.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{execution.getProcessInstanceId()}));
        }
        return result;
    }

    public List<ActivityInstanceResponse> createActivityInstanceResponseList(List<ActivityInstance> activityInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ActivityInstanceResponse> responseList = new ArrayList<ActivityInstanceResponse>(activityInstances.size());
        for (ActivityInstance instance : activityInstances) {
            responseList.add(this.createActivityInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public ActivityInstanceResponse createActivityInstanceResponse(ActivityInstance activityInstance) {
        return this.createActivityInstanceResponse(activityInstance, this.createUrlBuilder());
    }

    public ActivityInstanceResponse createActivityInstanceResponse(ActivityInstance activityInstance, RestUrlBuilder urlBuilder) {
        ActivityInstanceResponse result = new ActivityInstanceResponse();
        result.setActivityId(activityInstance.getActivityId());
        result.setActivityName(activityInstance.getActivityName());
        result.setActivityType(activityInstance.getActivityType());
        result.setAssignee(activityInstance.getAssignee());
        result.setCalledProcessInstanceId(activityInstance.getCalledProcessInstanceId());
        result.setDurationInMillis(activityInstance.getDurationInMillis());
        result.setEndTime(activityInstance.getEndTime());
        result.setExecutionId(activityInstance.getExecutionId());
        result.setId(activityInstance.getId());
        result.setProcessDefinitionId(activityInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{activityInstance.getProcessDefinitionId()}));
        result.setProcessInstanceId(activityInstance.getProcessInstanceId());
        result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{activityInstance.getProcessInstanceId()}));
        result.setStartTime(activityInstance.getStartTime());
        result.setTaskId(activityInstance.getTaskId());
        result.setTenantId(activityInstance.getTenantId());
        return result;
    }

    public List<VariableInstanceResponse> createVariableInstanceResponseList(List<VariableInstance> variableInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<VariableInstanceResponse> responseList = new ArrayList<VariableInstanceResponse>(variableInstances.size());
        for (VariableInstance instance : variableInstances) {
            responseList.add(this.createVariableInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public VariableInstanceResponse createVariableInstanceResponse(VariableInstance variableInstance) {
        return this.createVariableInstanceResponse(variableInstance, this.createUrlBuilder());
    }

    public VariableInstanceResponse createVariableInstanceResponse(VariableInstance variableInstance, RestUrlBuilder urlBuilder) {
        VariableInstanceResponse result = new VariableInstanceResponse();
        result.setId(variableInstance.getId());
        result.setProcessInstanceId(variableInstance.getProcessInstanceId());
        if (variableInstance.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{variableInstance.getProcessInstanceId()}));
        }
        result.setTaskId(variableInstance.getTaskId());
        result.setExecutionId(variableInstance.getExecutionId());
        RestVariable.RestVariableScope scope = variableInstance.getExecutionId() != null && !variableInstance.getExecutionId().equals(variableInstance.getProcessInstanceId()) || variableInstance.getTaskId() != null ? RestVariable.RestVariableScope.LOCAL : RestVariable.RestVariableScope.GLOBAL;
        result.setVariable(this.createRestVariable(variableInstance.getName(), variableInstance.getValue(), scope, variableInstance.getId(), 4, false, urlBuilder));
        return result;
    }

    public FormDataResponse createFormDataResponse(FormData formData) {
        TaskFormData taskFormData;
        FormDataResponse result = new FormDataResponse();
        result.setDeploymentId(formData.getDeploymentId());
        result.setFormKey(formData.getFormKey());
        if (formData.getFormProperties() != null) {
            for (FormProperty formProp : formData.getFormProperties()) {
                RestFormProperty restFormProp = new RestFormProperty();
                restFormProp.setId(formProp.getId());
                restFormProp.setName(formProp.getName());
                if (formProp.getType() != null) {
                    restFormProp.setType(formProp.getType().getName());
                }
                restFormProp.setValue(formProp.getValue());
                restFormProp.setReadable(formProp.isReadable());
                restFormProp.setRequired(formProp.isRequired());
                restFormProp.setWritable(formProp.isWritable());
                if ("enum".equals(restFormProp.getType())) {
                    Object values = formProp.getType().getInformation("values");
                    if (values != null) {
                        Map enumValues = (Map)values;
                        for (String enumId : enumValues.keySet()) {
                            RestEnumFormProperty enumProperty = new RestEnumFormProperty();
                            enumProperty.setId(enumId);
                            enumProperty.setName((String)enumValues.get(enumId));
                            restFormProp.addEnumValue(enumProperty);
                        }
                    }
                } else if ("date".equals(restFormProp.getType())) {
                    restFormProp.setDatePattern((String)formProp.getType().getInformation("datePattern"));
                }
                result.addFormProperty(restFormProp);
            }
        }
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        if (formData instanceof StartFormData) {
            StartFormData startFormData = (StartFormData)formData;
            if (startFormData.getProcessDefinition() != null) {
                result.setProcessDefinitionId(startFormData.getProcessDefinition().getId());
                result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{startFormData.getProcessDefinition().getId()}));
            }
        } else if (formData instanceof TaskFormData && (taskFormData = (TaskFormData)formData).getTask() != null) {
            result.setTaskId(taskFormData.getTask().getId());
            result.setTaskUrl(urlBuilder.buildUrl(RestUrls.URL_TASK, new Object[]{taskFormData.getTask().getId()}));
        }
        return result;
    }

    public List<HistoricProcessInstanceResponse> createHistoricProcessInstanceResponseList(List<HistoricProcessInstance> processInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricProcessInstanceResponse> responseList = new ArrayList<HistoricProcessInstanceResponse>(processInstances.size());
        for (HistoricProcessInstance instance : processInstances) {
            responseList.add(this.createHistoricProcessInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricProcessInstanceResponse createHistoricProcessInstanceResponse(HistoricProcessInstance processInstance) {
        return this.createHistoricProcessInstanceResponse(processInstance, this.createUrlBuilder());
    }

    public HistoricProcessInstanceResponse createHistoricProcessInstanceResponse(HistoricProcessInstance processInstance, RestUrlBuilder urlBuilder) {
        HistoricProcessInstanceResponse result = new HistoricProcessInstanceResponse();
        result.setBusinessKey(processInstance.getBusinessKey());
        result.setBusinessStatus(processInstance.getBusinessStatus());
        result.setDeleteReason(processInstance.getDeleteReason());
        result.setDurationInMillis(processInstance.getDurationInMillis());
        result.setEndActivityId(processInstance.getEndActivityId());
        result.setEndTime(processInstance.getEndTime());
        result.setId(processInstance.getId());
        result.setName(processInstance.getName());
        result.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processInstance.getProcessDefinitionId()}));
        result.setStartActivityId(processInstance.getStartActivityId());
        result.setStartTime(processInstance.getStartTime());
        result.setStartUserId(processInstance.getStartUserId());
        result.setSuperProcessInstanceId(processInstance.getSuperProcessInstanceId());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{processInstance.getId()}));
        if (processInstance.getProcessVariables() != null) {
            Map variableMap = processInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 6, false, urlBuilder));
            }
        }
        result.setCallbackId(processInstance.getCallbackId());
        result.setCallbackType(processInstance.getCallbackType());
        result.setReferenceId(processInstance.getReferenceId());
        result.setReferenceType(processInstance.getReferenceType());
        result.setPropagatedStageInstanceId(processInstance.getPropagatedStageInstanceId());
        result.setTenantId(processInstance.getTenantId());
        return result;
    }

    public List<HistoricTaskInstanceResponse> createHistoricTaskInstanceResponseList(List<HistoricTaskInstance> taskInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricTaskInstanceResponse> responseList = new ArrayList<HistoricTaskInstanceResponse>(taskInstances.size());
        for (HistoricTaskInstance instance : taskInstances) {
            responseList.add(this.createHistoricTaskInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricTaskInstanceResponse createHistoricTaskInstanceResponse(HistoricTaskInstance taskInstance) {
        return this.createHistoricTaskInstanceResponse(taskInstance, this.createUrlBuilder());
    }

    public HistoricTaskInstanceResponse createHistoricTaskInstanceResponse(HistoricTaskInstance taskInstance, RestUrlBuilder urlBuilder) {
        Map variableMap;
        HistoricTaskInstanceResponse result = new HistoricTaskInstanceResponse();
        result.setAssignee(taskInstance.getAssignee());
        result.setClaimTime(taskInstance.getClaimTime());
        result.setDeleteReason(taskInstance.getDeleteReason());
        result.setDescription(taskInstance.getDescription());
        result.setDueDate(taskInstance.getDueDate());
        result.setDurationInMillis(taskInstance.getDurationInMillis());
        result.setEndTime(taskInstance.getEndTime());
        result.setExecutionId(taskInstance.getExecutionId());
        result.setFormKey(taskInstance.getFormKey());
        result.setId(taskInstance.getId());
        result.setName(taskInstance.getName());
        result.setOwner(taskInstance.getOwner());
        result.setParentTaskId(taskInstance.getParentTaskId());
        result.setPriority(taskInstance.getPriority());
        result.setProcessDefinitionId(taskInstance.getProcessDefinitionId());
        result.setScopeDefinitionId(taskInstance.getScopeDefinitionId());
        result.setScopeId(taskInstance.getScopeId());
        result.setScopeType(taskInstance.getScopeType());
        result.setPropagatedStageInstanceId(taskInstance.getPropagatedStageInstanceId());
        result.setTenantId(taskInstance.getTenantId());
        result.setCategory(taskInstance.getCategory());
        if (taskInstance.getProcessDefinitionId() != null) {
            result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{taskInstance.getProcessDefinitionId()}));
        }
        result.setProcessInstanceId(taskInstance.getProcessInstanceId());
        if (taskInstance.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{taskInstance.getProcessInstanceId()}));
        }
        result.setStartTime(taskInstance.getStartTime());
        result.setTaskDefinitionKey(taskInstance.getTaskDefinitionKey());
        result.setWorkTimeInMillis(taskInstance.getWorkTimeInMillis());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{taskInstance.getId()}));
        if (taskInstance.getProcessVariables() != null) {
            variableMap = taskInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, taskInstance.getId(), 5, false, urlBuilder));
            }
        }
        if (taskInstance.getTaskLocalVariables() != null) {
            variableMap = taskInstance.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, taskInstance.getId(), 5, false, urlBuilder));
            }
        }
        return result;
    }

    public List<HistoricTaskLogEntryResponse> createHistoricTaskLogEntryResponseList(List<HistoricTaskLogEntry> logEntries) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricTaskLogEntryResponse> responseList = new ArrayList<HistoricTaskLogEntryResponse>(logEntries.size());
        for (HistoricTaskLogEntry instance : logEntries) {
            responseList.add(this.createHistoricTaskLogEntryResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricTaskLogEntryResponse createHistoricTaskLogEntryResponse(HistoricTaskLogEntry logEntry, RestUrlBuilder urlBuilder) {
        HistoricTaskLogEntryResponse response = new HistoricTaskLogEntryResponse();
        response.setLogNumber(logEntry.getLogNumber());
        response.setType(logEntry.getType());
        response.setTaskId(logEntry.getTaskId());
        response.setTimeStamp(logEntry.getTimeStamp());
        response.setUserId(logEntry.getUserId());
        response.setData(logEntry.getData());
        response.setExecutionId(logEntry.getExecutionId());
        response.setProcessInstanceId(logEntry.getProcessInstanceId());
        response.setProcessDefinitionId(logEntry.getProcessDefinitionId());
        response.setScopeId(logEntry.getScopeId());
        response.setScopeDefinitionId(logEntry.getScopeDefinitionId());
        response.setSubScopeId(logEntry.getSubScopeId());
        response.setScopeType(logEntry.getScopeType());
        response.setTenantId(logEntry.getTenantId());
        return response;
    }

    public List<HistoricActivityInstanceResponse> createHistoricActivityInstanceResponseList(List<HistoricActivityInstance> activityInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricActivityInstanceResponse> responseList = new ArrayList<HistoricActivityInstanceResponse>(activityInstances.size());
        for (HistoricActivityInstance instance : activityInstances) {
            responseList.add(this.createHistoricActivityInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricActivityInstanceResponse createHistoricActivityInstanceResponse(HistoricActivityInstance activityInstance) {
        return this.createHistoricActivityInstanceResponse(activityInstance, this.createUrlBuilder());
    }

    public HistoricActivityInstanceResponse createHistoricActivityInstanceResponse(HistoricActivityInstance activityInstance, RestUrlBuilder urlBuilder) {
        HistoricActivityInstanceResponse result = new HistoricActivityInstanceResponse();
        result.setActivityId(activityInstance.getActivityId());
        result.setActivityName(activityInstance.getActivityName());
        result.setActivityType(activityInstance.getActivityType());
        result.setAssignee(activityInstance.getAssignee());
        result.setCalledProcessInstanceId(activityInstance.getCalledProcessInstanceId());
        result.setDurationInMillis(activityInstance.getDurationInMillis());
        result.setEndTime(activityInstance.getEndTime());
        result.setExecutionId(activityInstance.getExecutionId());
        result.setId(activityInstance.getId());
        result.setProcessDefinitionId(activityInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{activityInstance.getProcessDefinitionId()}));
        result.setProcessInstanceId(activityInstance.getProcessInstanceId());
        result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{activityInstance.getProcessInstanceId()}));
        result.setStartTime(activityInstance.getStartTime());
        result.setTaskId(activityInstance.getTaskId());
        result.setTenantId(activityInstance.getTenantId());
        return result;
    }

    public List<HistoricVariableInstanceResponse> createHistoricVariableInstanceResponseList(List<HistoricVariableInstance> variableInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricVariableInstanceResponse> responseList = new ArrayList<HistoricVariableInstanceResponse>(variableInstances.size());
        for (HistoricVariableInstance instance : variableInstances) {
            responseList.add(this.createHistoricVariableInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricVariableInstanceResponse createHistoricVariableInstanceResponse(HistoricVariableInstance variableInstance) {
        return this.createHistoricVariableInstanceResponse(variableInstance, this.createUrlBuilder());
    }

    public HistoricVariableInstanceResponse createHistoricVariableInstanceResponse(HistoricVariableInstance variableInstance, RestUrlBuilder urlBuilder) {
        HistoricVariableInstanceResponse result = new HistoricVariableInstanceResponse();
        result.setId(variableInstance.getId());
        result.setProcessInstanceId(variableInstance.getProcessInstanceId());
        if (variableInstance.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{variableInstance.getProcessInstanceId()}));
        }
        RestVariable.RestVariableScope scope = variableInstance.getExecutionId() != null && !variableInstance.getExecutionId().equals(variableInstance.getProcessInstanceId()) || variableInstance.getTaskId() != null ? RestVariable.RestVariableScope.LOCAL : RestVariable.RestVariableScope.GLOBAL;
        result.setTaskId(variableInstance.getTaskId());
        result.setExecutionId(variableInstance.getExecutionId());
        result.setVariable(this.createRestVariable(variableInstance.getVariableName(), variableInstance.getValue(), scope, variableInstance.getId(), 7, false, urlBuilder));
        return result;
    }

    public List<HistoricDetailResponse> createHistoricDetailResponse(List<HistoricDetail> detailList) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricDetailResponse> responseList = new ArrayList<HistoricDetailResponse>(detailList.size());
        for (HistoricDetail instance : detailList) {
            responseList.add(this.createHistoricDetailResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricDetailResponse createHistoricDetailResponse(HistoricDetail detail) {
        return this.createHistoricDetailResponse(detail, this.createUrlBuilder());
    }

    public HistoricDetailResponse createHistoricDetailResponse(HistoricDetail detail, RestUrlBuilder urlBuilder) {
        HistoricDetailResponse result = new HistoricDetailResponse();
        result.setId(detail.getId());
        result.setProcessInstanceId(detail.getProcessInstanceId());
        if (StringUtils.isNotEmpty((CharSequence)detail.getProcessInstanceId())) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{detail.getProcessInstanceId()}));
        }
        result.setExecutionId(detail.getExecutionId());
        result.setActivityInstanceId(detail.getActivityInstanceId());
        result.setTaskId(detail.getTaskId());
        if (StringUtils.isNotEmpty((CharSequence)detail.getTaskId())) {
            result.setTaskUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{detail.getTaskId()}));
        }
        result.setTime(detail.getTime());
        if (detail instanceof HistoricFormProperty) {
            HistoricFormProperty formProperty = (HistoricFormProperty)detail;
            result.setDetailType("formProperty");
            result.setPropertyId(formProperty.getPropertyId());
            result.setPropertyValue(formProperty.getPropertyValue());
        } else if (detail instanceof HistoricVariableUpdate) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)detail;
            result.setDetailType("variableUpdate");
            result.setRevision(variableUpdate.getRevision());
            result.setVariable(this.createRestVariable(variableUpdate.getVariableName(), variableUpdate.getValue(), null, detail.getId(), 8, false, urlBuilder));
        }
        return result;
    }

    public List<HistoricIdentityLinkResponse> createHistoricIdentityLinkResponseList(List<HistoricIdentityLink> identityLinks) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricIdentityLinkResponse> responseList = new ArrayList<HistoricIdentityLinkResponse>(identityLinks.size());
        for (HistoricIdentityLink instance : identityLinks) {
            responseList.add(this.createHistoricIdentityLinkResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricIdentityLinkResponse createHistoricIdentityLinkResponse(HistoricIdentityLink identityLink) {
        return this.createHistoricIdentityLinkResponse(identityLink, this.createUrlBuilder());
    }

    public HistoricIdentityLinkResponse createHistoricIdentityLinkResponse(HistoricIdentityLink identityLink, RestUrlBuilder urlBuilder) {
        HistoricIdentityLinkResponse result = new HistoricIdentityLinkResponse();
        result.setType(identityLink.getType());
        result.setUserId(identityLink.getUserId());
        result.setGroupId(identityLink.getGroupId());
        result.setTaskId(identityLink.getTaskId());
        if (StringUtils.isNotEmpty((CharSequence)identityLink.getTaskId())) {
            result.setTaskUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{identityLink.getTaskId()}));
        }
        result.setProcessInstanceId(identityLink.getProcessInstanceId());
        if (StringUtils.isNotEmpty((CharSequence)identityLink.getProcessInstanceId())) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{identityLink.getProcessInstanceId()}));
        }
        return result;
    }

    public List<TableResponse> createTableResponseList(Map<String, Long> tableCounts) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<TableResponse> tables = new ArrayList<TableResponse>(tableCounts.size());
        for (Map.Entry<String, Long> entry : tableCounts.entrySet()) {
            tables.add(this.createTableResponse(entry.getKey(), entry.getValue(), urlBuilder));
        }
        return tables;
    }

    public TableResponse createTableResponse(String name, Long count) {
        return this.createTableResponse(name, count, this.createUrlBuilder());
    }

    public TableResponse createTableResponse(String name, Long count, RestUrlBuilder urlBuilder) {
        TableResponse result = new TableResponse();
        result.setName(name);
        result.setCount(count);
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_TABLE, new Object[]{name}));
        return result;
    }

    public List<JobResponse> createJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, RestUrls.URL_JOB);
    }

    public List<JobResponse> createTimerJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, RestUrls.URL_TIMER_JOB);
    }

    public List<JobResponse> createSuspendedJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, RestUrls.URL_SUSPENDED_JOB);
    }

    public List<JobResponse> createDeadLetterJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, RestUrls.URL_DEADLETTER_JOB);
    }

    protected List<JobResponse> createJobResponseList(List<Job> jobs, String[] urlJobSegments) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<JobResponse> responseList = new ArrayList<JobResponse>(jobs.size());
        for (Job instance : jobs) {
            responseList.add(this.createJobResponse(instance, urlBuilder, urlJobSegments));
        }
        return responseList;
    }

    public JobResponse createJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder());
    }

    public JobResponse createTimerJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder(), RestUrls.URL_TIMER_JOB);
    }

    public JobResponse createSuspendedJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder(), RestUrls.URL_SUSPENDED_JOB);
    }

    public JobResponse createDeadLetterJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder(), RestUrls.URL_DEADLETTER_JOB);
    }

    public JobResponse createJobResponse(Job job, RestUrlBuilder urlBuilder) {
        return this.createJobResponse(job, urlBuilder, RestUrls.URL_JOB);
    }

    protected JobResponse createJobResponse(Job job, RestUrlBuilder urlBuilder, String[] urlJobSegments) {
        JobResponse response = new JobResponse();
        response.setId(job.getId());
        response.setCorrelationId(job.getCorrelationId());
        response.setDueDate(job.getDuedate());
        response.setExceptionMessage(job.getExceptionMessage());
        response.setExecutionId(job.getExecutionId());
        response.setProcessDefinitionId(job.getProcessDefinitionId());
        response.setProcessInstanceId(job.getProcessInstanceId());
        response.setElementId(job.getElementId());
        response.setElementName(job.getElementName());
        response.setRetries(job.getRetries());
        response.setCreateTime(job.getCreateTime());
        if (job instanceof JobInfoEntity) {
            JobInfoEntity jobInfoEntity = (JobInfoEntity)job;
            response.setLockOwner(jobInfoEntity.getLockOwner());
            response.setLockExpirationTime(jobInfoEntity.getLockExpirationTime());
        }
        response.setTenantId(job.getTenantId());
        response.setUrl(urlBuilder.buildUrl(urlJobSegments, new Object[]{job.getId()}));
        if (job.getProcessDefinitionId() != null) {
            response.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{job.getProcessDefinitionId()}));
        }
        if (job.getProcessInstanceId() != null) {
            response.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{job.getProcessInstanceId()}));
        }
        if (job.getExecutionId() != null) {
            response.setExecutionUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION, new Object[]{job.getExecutionId()}));
        }
        return response;
    }

    public List<HistoryJobResponse> createHistoryJobResponseList(List<HistoryJob> jobs) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoryJobResponse> responseList = new ArrayList<HistoryJobResponse>(jobs.size());
        for (HistoryJob job : jobs) {
            responseList.add(this.createHistoryJobResponse(job, urlBuilder));
        }
        return responseList;
    }

    public HistoryJobResponse createHistoryJobResponse(HistoryJob job) {
        return this.createHistoryJobResponse(job, this.createUrlBuilder());
    }

    public HistoryJobResponse createHistoryJobResponse(HistoryJob job, RestUrlBuilder urlBuilder) {
        HistoryJobResponse response = new HistoryJobResponse();
        response.setId(job.getId());
        response.setExceptionMessage(job.getExceptionMessage());
        response.setRetries(job.getRetries());
        response.setCreateTime(job.getCreateTime());
        response.setScopeType(job.getScopeType());
        response.setJobHandlerType(job.getJobHandlerType());
        response.setJobHandlerConfiguration(job.getJobHandlerConfiguration());
        response.setCustomValues(job.getCustomValues());
        if (job instanceof HistoryJobEntity) {
            HistoryJobEntity historyJobEntity = (HistoryJobEntity)job;
            response.setLockOwner(historyJobEntity.getLockOwner());
            response.setLockExpirationTime(historyJobEntity.getLockExpirationTime());
        }
        response.setTenantId(job.getTenantId());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORY_JOB, new Object[]{job.getId()}));
        return response;
    }

    public List<BatchResponse> createBatchResponse(List<Batch> batches) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<BatchResponse> responseList = new ArrayList<BatchResponse>(batches.size());
        for (Batch instance : batches) {
            responseList.add(this.createBatchResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public BatchResponse createBatchResponse(Batch batch) {
        return this.createBatchResponse(batch, this.createUrlBuilder());
    }

    public BatchResponse createBatchResponse(Batch batch, RestUrlBuilder urlBuilder) {
        BatchResponse response = new BatchResponse();
        response.setId(batch.getId());
        response.setBatchType(batch.getBatchType());
        response.setSearchKey(batch.getBatchSearchKey());
        response.setSearchKey2(batch.getBatchSearchKey2());
        response.setCreateTime(batch.getCreateTime());
        response.setCompleteTime(batch.getCompleteTime());
        response.setStatus(batch.getStatus());
        response.setTenantId(batch.getTenantId());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_BATCH, new Object[]{batch.getId()}));
        return response;
    }

    public List<BatchPartResponse> createBatchPartResponse(List<BatchPart> batchParts) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<BatchPartResponse> responseList = new ArrayList<BatchPartResponse>(batchParts.size());
        for (BatchPart instance : batchParts) {
            responseList.add(this.createBatchPartResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public BatchPartResponse createBatchPartResponse(BatchPart batchPart) {
        return this.createBatchPartResponse(batchPart, this.createUrlBuilder());
    }

    public BatchPartResponse createBatchPartResponse(BatchPart batchPart, RestUrlBuilder urlBuilder) {
        BatchPartResponse response = new BatchPartResponse();
        response.setId(batchPart.getId());
        response.setBatchId(batchPart.getBatchId());
        response.setBatchType(batchPart.getBatchType());
        response.setSearchKey(batchPart.getBatchSearchKey());
        response.setSearchKey2(batchPart.getBatchSearchKey2());
        response.setScopeId(batchPart.getScopeId());
        response.setSubScopeId(batchPart.getSubScopeId());
        response.setScopeType(batchPart.getScopeType());
        response.setCreateTime(batchPart.getCreateTime());
        response.setCompleteTime(batchPart.getCompleteTime());
        response.setStatus(batchPart.getStatus());
        response.setTenantId(batchPart.getTenantId());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_BATCH_PART, new Object[]{batchPart.getId()}));
        response.setBatchUrl(urlBuilder.buildUrl(RestUrls.URL_BATCH, new Object[]{batchPart.getBatchId()}));
        return response;
    }

    public List<EventSubscriptionResponse> createEventSubscriptionResponseList(List<EventSubscription> eventSubscriptions) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<EventSubscriptionResponse> responseList = new ArrayList<EventSubscriptionResponse>(eventSubscriptions.size());
        for (EventSubscription instance : eventSubscriptions) {
            responseList.add(this.createEventSubscriptionResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public EventSubscriptionResponse createEventSubscriptionResponse(EventSubscription eventSubscription) {
        return this.createEventSubscriptionResponse(eventSubscription, this.createUrlBuilder());
    }

    public EventSubscriptionResponse createEventSubscriptionResponse(EventSubscription eventSubscription, RestUrlBuilder urlBuilder) {
        EventSubscriptionResponse response = new EventSubscriptionResponse();
        response.setId(eventSubscription.getId());
        response.setCreated(eventSubscription.getCreated());
        response.setEventType(eventSubscription.getEventType());
        response.setEventName(eventSubscription.getEventName());
        response.setActivityId(eventSubscription.getActivityId());
        response.setExecutionId(eventSubscription.getExecutionId());
        response.setProcessDefinitionId(eventSubscription.getProcessDefinitionId());
        response.setProcessInstanceId(eventSubscription.getProcessInstanceId());
        response.setScopeId(eventSubscription.getScopeId());
        response.setScopeType(eventSubscription.getScopeType());
        response.setSubScopeId(eventSubscription.getSubScopeId());
        response.setScopeDefinitionId(eventSubscription.getScopeDefinitionId());
        response.setConfiguration(eventSubscription.getConfiguration());
        response.setTenantId(eventSubscription.getTenantId());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_EVENT_SUBSCRIPTION, new Object[]{eventSubscription.getId()}));
        if (eventSubscription.getProcessDefinitionId() != null) {
            response.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{eventSubscription.getProcessDefinitionId()}));
        }
        if (eventSubscription.getProcessInstanceId() != null) {
            response.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{eventSubscription.getProcessInstanceId()}));
        }
        if (eventSubscription.getExecutionId() != null) {
            response.setExecutionUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION, new Object[]{eventSubscription.getExecutionId()}));
        }
        return response;
    }

    public List<UserResponse> createUserResponseList(List<User> users) {
        return this.createUserResponseList(users, false);
    }

    public List<UserResponse> createUserResponseList(List<User> users, boolean includePassword) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<UserResponse> responseList = new ArrayList<UserResponse>(users.size());
        for (User instance : users) {
            responseList.add(this.createUserResponse(instance, includePassword, urlBuilder));
        }
        return responseList;
    }

    public UserResponse createUserResponse(User user, boolean includePassword) {
        return this.createUserResponse(user, includePassword, this.createUrlBuilder());
    }

    public UserResponse createUserResponse(User user, boolean incudePassword, RestUrlBuilder urlBuilder) {
        UserResponse response = new UserResponse();
        response.setFirstName(user.getFirstName());
        response.setLastName(user.getLastName());
        response.setDisplayName(user.getDisplayName());
        response.setId(user.getId());
        response.setEmail(user.getEmail());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_USER, new Object[]{user.getId()}));
        response.setTenantId(user.getTenantId());
        if (incudePassword) {
            response.setPassword(user.getPassword());
        }
        if (user.isPictureSet()) {
            response.setPictureUrl(urlBuilder.buildUrl(RestUrls.URL_USER_PICTURE, new Object[]{user.getId()}));
        }
        return response;
    }

    public List<UserInfoResponse> createUserInfoKeysResponse(List<String> keys, String userId) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<UserInfoResponse> responseList = new ArrayList<UserInfoResponse>(keys.size());
        for (String instance : keys) {
            responseList.add(this.createUserInfoResponse(instance, null, userId, urlBuilder));
        }
        return responseList;
    }

    public UserInfoResponse createUserInfoResponse(String key, String value, String userId) {
        return this.createUserInfoResponse(key, value, userId, this.createUrlBuilder());
    }

    public UserInfoResponse createUserInfoResponse(String key, String value, String userId, RestUrlBuilder urlBuilder) {
        UserInfoResponse response = new UserInfoResponse();
        response.setKey(key);
        response.setValue(value);
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_USER_INFO, new Object[]{userId, key}));
        return response;
    }

    public List<GroupResponse> createGroupResponseList(List<Group> groups) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<GroupResponse> responseList = new ArrayList<GroupResponse>(groups.size());
        for (Group instance : groups) {
            responseList.add(this.createGroupResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public GroupResponse createGroupResponse(Group group) {
        return this.createGroupResponse(group, this.createUrlBuilder());
    }

    public GroupResponse createGroupResponse(Group group, RestUrlBuilder urlBuilder) {
        GroupResponse response = new GroupResponse();
        response.setId(group.getId());
        response.setName(group.getName());
        response.setType(group.getType());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_GROUP, new Object[]{group.getId()}));
        return response;
    }

    public MembershipResponse createMembershipResponse(String userId, String groupId) {
        return this.createMembershipResponse(userId, groupId, this.createUrlBuilder());
    }

    public MembershipResponse createMembershipResponse(String userId, String groupId, RestUrlBuilder urlBuilder) {
        MembershipResponse response = new MembershipResponse();
        response.setGroupId(groupId);
        response.setUserId(userId);
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_GROUP_MEMBERSHIP, new Object[]{groupId, userId}));
        return response;
    }

    public List<ModelResponse> createModelResponseList(List<Model> models) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ModelResponse> responseList = new ArrayList<ModelResponse>(models.size());
        for (Model instance : models) {
            responseList.add(this.createModelResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public ModelResponse createModelResponse(Model model) {
        return this.createModelResponse(model, this.createUrlBuilder());
    }

    public ModelResponse createModelResponse(Model model, RestUrlBuilder urlBuilder) {
        ModelResponse response = new ModelResponse();
        response.setCategory(model.getCategory());
        response.setCreateTime(model.getCreateTime());
        response.setId(model.getId());
        response.setKey(model.getKey());
        response.setLastUpdateTime(model.getLastUpdateTime());
        response.setMetaInfo(model.getMetaInfo());
        response.setName(model.getName());
        response.setDeploymentId(model.getDeploymentId());
        response.setVersion(model.getVersion());
        response.setTenantId(model.getTenantId());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_MODEL, new Object[]{model.getId()}));
        if (model.getDeploymentId() != null) {
            response.setDeploymentUrl(urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT, new Object[]{model.getDeploymentId()}));
        }
        if (model.hasEditorSource()) {
            response.setSourceUrl(urlBuilder.buildUrl(RestUrls.URL_MODEL_SOURCE, new Object[]{model.getId()}));
        }
        if (model.hasEditorSourceExtra()) {
            response.setSourceExtraUrl(urlBuilder.buildUrl(RestUrls.URL_MODEL_SOURCE_EXTRA, new Object[]{model.getId()}));
        }
        return response;
    }

    public List<DecisionResponse> createDecisionResponseList(List<DmnDecision> decisions, String processDefinitionId) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DecisionResponse> responseList = new ArrayList<DecisionResponse>(decisions.size());
        for (DmnDecision decision : decisions) {
            responseList.add(this.createDecisionResponse(decision, processDefinitionId, urlBuilder));
        }
        return responseList;
    }

    public DecisionResponse createDecisionResponse(DmnDecision decision, String processDefinitionId) {
        return this.createDecisionResponse(decision, processDefinitionId, this.createUrlBuilder());
    }

    public DecisionResponse createDecisionResponse(DmnDecision decision, String processDefinitionId, RestUrlBuilder urlBuilder) {
        DecisionResponse decisionResponse = new DecisionResponse(decision);
        decisionResponse.setUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION_DECISION_COLLECTION, new Object[]{processDefinitionId}));
        return decisionResponse;
    }

    public List<FormDefinitionResponse> createFormDefinitionResponseList(List<FormDefinition> formDefinitions, String processDefinitionId) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<FormDefinitionResponse> responseList = new ArrayList<FormDefinitionResponse>(formDefinitions.size());
        for (FormDefinition formDefinition : formDefinitions) {
            responseList.add(this.createFormDefinitionResponse(formDefinition, processDefinitionId, urlBuilder));
        }
        return responseList;
    }

    public FormDefinitionResponse createFormDefintionResponse(FormDefinition formDefinition, String processDefinitionId) {
        return this.createFormDefinitionResponse(formDefinition, processDefinitionId, this.createUrlBuilder());
    }

    public FormDefinitionResponse createFormDefinitionResponse(FormDefinition formDefinition, String processDefinitionId, RestUrlBuilder urlBuilder) {
        FormDefinitionResponse formDefinitionResponse = new FormDefinitionResponse(formDefinition);
        formDefinitionResponse.setUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION_FORM_DEFINITIONS_COLLECTION, new Object[]{processDefinitionId}));
        return formDefinitionResponse;
    }

    public List<RestVariableConverter> getVariableConverters() {
        return this.variableConverters;
    }

    protected void initializeVariableConverters() {
        this.variableConverters.add((RestVariableConverter)new StringRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new IntegerRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LongRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new ShortRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DoubleRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new BooleanRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new InstantRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateTimeRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new JsonObjectRestVariableConverter(this.objectMapper));
    }

    protected String formatUrl(String serverRootUrl, String[] fragments, Object ... arguments) {
        StringBuilder urlBuilder = new StringBuilder(serverRootUrl);
        for (String urlFragment : fragments) {
            urlBuilder.append("/");
            urlBuilder.append(MessageFormat.format(urlFragment, arguments));
        }
        return urlBuilder.toString();
    }

    protected RestUrlBuilder createUrlBuilder() {
        return RestUrlBuilder.fromCurrentRequest();
    }
}

