/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.HistoryService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Task"}, description="Manage History Task Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricTaskInstanceVariableDataResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get the binary data for a historic task instance variable", tags={"History"}, nickname="getHistoricTaskInstanceVariableData", notes="The response body contains the binary value of the variable. When the variable is of type binary, the content-type of the response is set to application/octet-stream, regardless of the content of the variable or the request accept-type header. In case of serializable, application/x-java-serialized-object is used as content-type.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task instance was found and the requested variable data is returned."), @ApiResponse(code=404, message="Indicates the requested task instance was not found or the process instance does not have a variable with the given name or the variable does not have a binary stream available. Status message provides additional information.")})
    @GetMapping(value={"/history/historic-task-instances/{taskId}/variables/{variableName}/data"})
    @ResponseBody
    public byte[] getVariableData(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(true, taskId, variableName, scope);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FlowableException("Unexpected exception getting variable data", (Throwable)ioe);
        }
    }

    public RestVariable getVariableFromRequest(boolean includeBinary, String taskId, String variableName, String scope) {
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(scope);
        HistoricTaskInstanceQuery taskQuery = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        if (variableScope != null) {
            if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
                taskQuery.includeProcessVariables();
            } else {
                taskQuery.includeTaskLocalVariables();
            }
        } else {
            ((HistoricTaskInstanceQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        HistoricTaskInstance taskObject = (HistoricTaskInstance)taskQuery.singleResult();
        if (taskObject == null) {
            throw new FlowableObjectNotFoundException("Historic task instance '" + taskId + "' could not be found.", HistoricTaskInstanceEntity.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryTaskInfoById(taskObject);
        }
        Object value = null;
        value = variableScope != null ? (variableScope == RestVariable.RestVariableScope.GLOBAL ? taskObject.getProcessVariables().get(variableName) : taskObject.getTaskLocalVariables().get(variableName)) : (taskObject.getTaskLocalVariables().containsKey(variableName) ? taskObject.getTaskLocalVariables().get(variableName) : taskObject.getProcessVariables().get(variableName));
        if (value == null) {
            throw new FlowableObjectNotFoundException("Historic task instance '" + taskId + "' variable value for " + variableName + " could not be found.", VariableInstanceEntity.class);
        }
        return this.restResponseFactory.createRestVariable(variableName, value, null, taskId, 5, includeBinary);
    }
}

