/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.image.ProcessDiagramGenerator;
import org.flowable.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Instances"}, description="Manage Process Instances", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceDiagramResource
extends BaseProcessInstanceResource {
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ProcessEngineConfiguration processEngineConfiguration;

    @ApiOperation(value="Get diagram for a process instance", tags={"Process Instances"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and the diagram was returned."), @ApiResponse(code=400, message="Indicates the requested process instance was not found but the process does not contain any graphical information (BPMN:DI) and no diagram can be created."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @GetMapping(value={"/runtime/process-instances/{processInstanceId}/diagram"})
    public ResponseEntity<byte[]> getProcessInstanceDiagram(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        ProcessDefinition pde = this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        if (pde != null && pde.hasGraphicalNotation()) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pde.getId());
            ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
            InputStream resource = diagramGenerator.generateDiagram(bpmnModel, "png", this.runtimeService.getActiveActivityIds(processInstance.getId()), Collections.emptyList(), this.processEngineConfiguration.getActivityFontName(), this.processEngineConfiguration.getLabelFontName(), this.processEngineConfiguration.getAnnotationFontName(), this.processEngineConfiguration.getClassLoader(), 1.0, this.processEngineConfiguration.isDrawSequenceFlowNameWithNoLabelDI());
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", "image/png");
            try {
                return new ResponseEntity((Object)IOUtils.toByteArray((InputStream)resource), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception e) {
                throw new FlowableIllegalArgumentException("Error exporting diagram", (Throwable)e);
            }
        }
        throw new FlowableIllegalArgumentException("Process instance with id '" + processInstance.getId() + "' has no graphical notation defined.");
    }
}

