/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.flowable.engine.runtime.Execution;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.rest.service.api.runtime.process.BaseVariableCollectionResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Instance Variables"}, description="Manage Process Instances Variables", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceVariableCollectionResource
extends BaseVariableCollectionResource {
    public ProcessInstanceVariableCollectionResource() {
        super(3);
    }

    @ApiOperation(value="List variables for a process instance", nickname="listProcessInstanceVariables", tags={"Process Instance Variables"}, notes="In case the variable is a binary variable or serializable, the valueUrl points to an URL to fetch the raw value. If it\u2019s a plain variable, the value is present in the response. Note that only local scoped variables are returned, as there is no global scope for process-instance variables.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and variables are returned."), @ApiResponse(code=400, message="Indicates the requested process instance was not found.")})
    @GetMapping(value={"/runtime/process-instances/{processInstanceId}/variables"}, produces={"application/json"})
    public List<RestVariable> getVariables(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestParam(value="scope", required=false) String scope) {
        Execution execution = this.getExecutionFromRequestWithoutAccessCheck(processInstanceId);
        return this.processVariables(execution, scope);
    }

    @ApiOperation(value="Update a multiple/single (non)binary variable on a process instance", tags={"Process Instance Variables"}, nickname="createOrUpdateProcessVariable", notes="This endpoint can be used in 2 ways: By passing a JSON Body (RestVariable or an array of RestVariable) or by passing a multipart/form-data Object.\nNonexistent variables are created on the process-instance and existing ones are overridden without any error.\nAny number of variables can be passed into the request body array.\nNote that scope is ignored, only local variables can be set in a process instance.\nNB: Swagger V2 specification does not support this use case that is why this endpoint might be buggy/incomplete if used with other tools.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", type="org.flowable.rest.service.api.engine.variable.RestVariable", value="Create a variable on a process instance", paramType="body", example="{\n    \"name\":\"intProcVar\"\n    \"type\":\"integer\"\n    \"value\":123,\n }"), @ApiImplicitParam(name="file", dataType="file", paramType="form"), @ApiImplicitParam(name="name", dataType="string", paramType="form", example="Simple content item"), @ApiImplicitParam(name="type", dataType="string", paramType="form", example="integer")})
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the process instance was found and variable is created."), @ApiResponse(code=400, message="Indicates the request body is incomplete or contains illegal values. The status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the requested process instance was not found."), @ApiResponse(code=415, message="Indicates the serializable data contains an object for which no class is present in the JVM running the Flowable engine and therefore cannot be deserialized.")})
    @PutMapping(value={"/runtime/process-instances/{processInstanceId}/variables"}, produces={"application/json"}, consumes={"application/json", "multipart/form-data"})
    public Object createOrUpdateExecutionVariable(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getExecutionFromRequestWithoutAccessCheck(processInstanceId);
        return this.createExecutionVariable(execution, true, request, response);
    }

    @ApiOperation(value="Create variables or new binary variable on a process instance", tags={"Process Instance Variables"}, nickname="createProcessInstanceVariable", notes="This endpoint can be used in 2 ways: By passing a JSON Body (RestVariable or an array of RestVariable) or by passing a multipart/form-data Object.\nNonexistent variables are created on the process-instance and existing ones are overridden without any error.\nAny number of variables can be passed into the request body array.\nNote that scope is ignored, only local variables can be set in a process instance.\nNB: Swagger V2 specification does not support this use case that is why this endpoint might be buggy/incomplete if used with other tools.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", type="org.flowable.rest.service.api.engine.variable.RestVariable", value="Create a variable on a process instance", paramType="body", example="{\n    \"name\":\"intProcVar\"\n    \"type\":\"integer\"\n    \"value\":123,\n }"), @ApiImplicitParam(name="file", dataType="file", paramType="form"), @ApiImplicitParam(name="name", dataType="string", paramType="form", example="Simple content item"), @ApiImplicitParam(name="type", dataType="string", paramType="form", example="integer")})
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the process instance was found and variable is created."), @ApiResponse(code=400, message="Indicates the request body is incomplete or contains illegal values. The status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the requested process instance was not found."), @ApiResponse(code=409, message="Indicates the process instance was found but already contains a variable with the given name (only thrown when POST method is used). Use the update-method instead.")})
    @PostMapping(value={"/runtime/process-instances/{processInstanceId}/variables"}, produces={"application/json"}, consumes={"application/json", "multipart/form-data"})
    public Object createExecutionVariable(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getExecutionFromRequestWithoutAccessCheck(processInstanceId);
        return this.createExecutionVariable(execution, false, request, response);
    }

    @ApiOperation(value="Delete all variables", tags={"Process Instance Variables"}, nickname="deleteLocalProcessVariable", code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates variables were found and have been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @DeleteMapping(value={"/runtime/process-instances/{processInstanceId}/variables"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteLocalVariables(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId) {
        Execution execution = this.getExecutionFromRequestWithoutAccessCheck(processInstanceId);
        this.deleteAllLocalVariables(execution);
    }

    @Override
    protected void addGlobalVariables(Execution execution, Map<String, RestVariable> variableMap) {
    }

    @Override
    protected void addLocalVariables(Execution execution, Map<String, RestVariable> variableMap) {
        Map rawVariables = this.runtimeService.getVariables(execution.getId());
        List<RestVariable> globalVariables = this.restResponseFactory.createRestVariables(rawVariables, execution.getId(), this.variableType, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : globalVariables) {
            if (variableMap.containsKey(var.getName())) continue;
            variableMap.put(var.getName(), var);
        }
    }
}

