/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import org.flowable.batch.api.BatchQuery;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.RequestUtil;
import org.flowable.engine.ManagementService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.management.BatchResponse;
import org.flowable.rest.service.api.management.JobQueryProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Batches"}, description="Manage Batches", authorizations={@Authorization(value="basicAuth")})
public class BatchCollectionResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ManagementService managementService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List batches", tags={"Batches"}, nickname="listBatches")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="string", value="Only return batch with the given id", paramType="query"), @ApiImplicitParam(name="batchType", dataType="string", value="Only return batches for the given type", paramType="query"), @ApiImplicitParam(name="searchKey", dataType="string", value="Only return batches for the given search key", paramType="query"), @ApiImplicitParam(name="searchKey2", dataType="string", value="Only return batches for the given search key2", paramType="query"), @ApiImplicitParam(name="createTimeBefore", dataType="string", format="date-time", value="Only return batches created before the given date", paramType="query"), @ApiImplicitParam(name="createTimeAfter", dataType="string", format="date-time", value="Only batches batches created after the given date", paramType="query"), @ApiImplicitParam(name="completeTimeBefore", dataType="string", format="date-time", value="Only return batches completed before the given date", paramType="query"), @ApiImplicitParam(name="completeTimeAfter", dataType="string", format="date-time", value="Only batches batches completed after the given date", paramType="query"), @ApiImplicitParam(name="status", dataType="string", value="Only return batches for the given status", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return batches for the given tenant id", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return batches like given search key", paramType="query"), @ApiImplicitParam(name="withoutTenantId", dataType="boolean", value="If true, only returns batches without a tenantId set. If false, the withoutTenantId parameter is ignored.", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested batches were returned."), @ApiResponse(code=400, message="Indicates an illegal value has been used in a url query parameter. Status description contains additional details about the error.")})
    @GetMapping(value={"/management/batches"}, produces={"application/json"})
    public DataResponse<BatchResponse> getBatches(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        BatchQuery query = this.managementService.createBatchQuery();
        if (allRequestParams.containsKey("id")) {
            query.batchId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("batchType")) {
            query.batchType(allRequestParams.get("batchType"));
        }
        if (allRequestParams.containsKey("searchKey")) {
            query.searchKey(allRequestParams.get("searchKey"));
        }
        if (allRequestParams.containsKey("searchKey2")) {
            query.searchKey2(allRequestParams.get("searchKey2"));
        }
        if (allRequestParams.containsKey("createTimeBefore")) {
            query.createTimeLowerThan(RequestUtil.getDate(allRequestParams, (String)"createTimeBefore"));
        }
        if (allRequestParams.containsKey("createTimeAfter")) {
            query.createTimeHigherThan(RequestUtil.getDate(allRequestParams, (String)"createTimeAfter"));
        }
        if (allRequestParams.containsKey("completeTimeBefore")) {
            query.completeTimeLowerThan(RequestUtil.getDate(allRequestParams, (String)"completeTimeBefore"));
        }
        if (allRequestParams.containsKey("completeTimeAfter")) {
            query.completeTimeHigherThan(RequestUtil.getDate(allRequestParams, (String)"completeTimeAfter"));
        }
        if (allRequestParams.containsKey("status")) {
            query.status(allRequestParams.get("status"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            query.tenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            query.tenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && Boolean.parseBoolean(allRequestParams.get("withoutTenantId"))) {
            query.withoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessBatchInfoWithQuery(query);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)query, (String)"id", JobQueryProperties.PROPERTIES, this.restResponseFactory::createBatchResponse);
    }
}

