/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.servlet;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableServletContextListener
implements ServletContextListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FlowableServletContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        LOGGER.info("Booting Flowable Process Engine");
        ProcessEngine processEngine = null;
        try {
            processEngine = ProcessEngines.getDefaultProcessEngine();
        }
        catch (Exception e) {
            LOGGER.error("Error starting the Flowable REST API", (Throwable)e);
        }
        if (processEngine == null) {
            LOGGER.error("Could not start the Flowable REST API");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        LOGGER.info("Destroying Flowable Process Engine");
        ProcessEngines.destroy();
    }
}

