/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.engine.impl.ModelQueryProperty;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ModelQuery;
import org.flowable.rest.service.api.repository.BaseModelResource;
import org.flowable.rest.service.api.repository.ModelRequest;
import org.flowable.rest.service.api.repository.ModelResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Models"}, description="Manage Models", authorizations={@Authorization(value="basicAuth")})
public class ModelCollectionResource
extends BaseModelResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();

    @ApiOperation(value="List models", nickname="listModels", tags={"Models"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="string", value="Only return models with the given version.", paramType="query"), @ApiImplicitParam(name="category", dataType="string", value="Only return models with the given category.", paramType="query"), @ApiImplicitParam(name="categoryLike", dataType="string", value="Only return models with a category like the given name.", paramType="query"), @ApiImplicitParam(name="categoryNotEquals", dataType="string", value="Only return models which do not have the given category.", paramType="query"), @ApiImplicitParam(name="name", dataType="string", value="Only return models with the given name.", paramType="query"), @ApiImplicitParam(name="nameLike", dataType="string", value="Only return models with a name like the given name.", paramType="query"), @ApiImplicitParam(name="key", dataType="string", value="Only return models with the given key.", paramType="query"), @ApiImplicitParam(name="deploymentId", dataType="string", value="Only return models with the given category.", paramType="query"), @ApiImplicitParam(name="version", dataType="integer", value="Only return models with the given version.", paramType="query"), @ApiImplicitParam(name="latestVersion", dataType="boolean", value="If true, only return models which are the latest version. Best used in combination with key. If false is passed in as value, this is ignored and all versions are returned.", paramType="query"), @ApiImplicitParam(name="deployed", dataType="boolean", value="If true, only deployed models are returned. If false, only undeployed models are returned (deploymentId is null).", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return models with the given tenantId.", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return models with a tenantId like the given value.", paramType="query"), @ApiImplicitParam(name="withoutTenantId", dataType="boolean", value="If true, only returns models without a tenantId set. If false, the withoutTenantId parameter is ignored.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="id,category,createTime,key,lastUpdateTime,name,version,tenantId", paramType="query"), @ApiImplicitParam(name="order", dataType="string", value="The sort order, either 'asc' or 'desc'. Defaults to 'asc'.", paramType="query"), @ApiImplicitParam(name="start", dataType="integer", value="Index of the first row to fetch. Defaults to 0.", paramType="query"), @ApiImplicitParam(name="size", dataType="integer", value="Number of rows to fetch, starting from start. Defaults to 10.", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the models are returned"), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format. The status-message contains additional information.")})
    @GetMapping(value={"/repository/models"}, produces={"application/json"})
    public DataResponse<ModelResponse> getModels(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        boolean withoutTenantId;
        boolean isLatestVersion;
        ModelQuery modelQuery = this.repositoryService.createModelQuery();
        if (allRequestParams.containsKey("id")) {
            modelQuery.modelId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("category")) {
            modelQuery.modelCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryLike")) {
            modelQuery.modelCategoryLike(allRequestParams.get("categoryLike"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            modelQuery.modelCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("name")) {
            modelQuery.modelName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            modelQuery.modelNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("key")) {
            modelQuery.modelKey(allRequestParams.get("key"));
        }
        if (allRequestParams.containsKey("version")) {
            modelQuery.modelVersion(Integer.valueOf(allRequestParams.get("version")));
        }
        if (allRequestParams.containsKey("latestVersion") && (isLatestVersion = Boolean.parseBoolean(allRequestParams.get("latestVersion")))) {
            modelQuery.latestVersion();
        }
        if (allRequestParams.containsKey("deploymentId")) {
            modelQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("deployed")) {
            boolean isDeployed = Boolean.parseBoolean(allRequestParams.get("deployed"));
            if (isDeployed) {
                modelQuery.deployed();
            } else {
                modelQuery.notDeployed();
            }
        }
        if (allRequestParams.containsKey("tenantId")) {
            modelQuery.modelTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            modelQuery.modelTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && (withoutTenantId = Boolean.parseBoolean(allRequestParams.get("withoutTenantId")))) {
            modelQuery.modelWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessModelInfoWithQuery(modelQuery);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)modelQuery, (String)"id", allowedSortProperties, this.restResponseFactory::createModelResponseList);
    }

    @ApiOperation(value="Create a model", tags={"Models"}, notes="All request values are optional. For example, you can only include the name attribute in the request body JSON-object, only setting the name of the model, leaving all other fields null.", code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the model was created.")})
    @PostMapping(value={"/repository/models"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ModelResponse createModel(@RequestBody ModelRequest modelRequest) {
        Model model = this.repositoryService.newModel();
        model.setCategory(modelRequest.getCategory());
        model.setDeploymentId(modelRequest.getDeploymentId());
        model.setKey(modelRequest.getKey());
        model.setMetaInfo(modelRequest.getMetaInfo());
        model.setName(modelRequest.getName());
        model.setVersion(modelRequest.getVersion());
        model.setTenantId(modelRequest.getTenantId());
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.createModel(model, modelRequest);
        }
        this.repositoryService.saveModel(model);
        return this.restResponseFactory.createModelResponse(model);
    }

    static {
        allowedSortProperties.put("id", (QueryProperty)ModelQueryProperty.MODEL_ID);
        allowedSortProperties.put("category", (QueryProperty)ModelQueryProperty.MODEL_CATEGORY);
        allowedSortProperties.put("createTime", (QueryProperty)ModelQueryProperty.MODEL_CREATE_TIME);
        allowedSortProperties.put("key", (QueryProperty)ModelQueryProperty.MODEL_KEY);
        allowedSortProperties.put("lastUpdateTime", (QueryProperty)ModelQueryProperty.MODEL_LAST_UPDATE_TIME);
        allowedSortProperties.put("name", (QueryProperty)ModelQueryProperty.MODEL_NAME);
        allowedSortProperties.put("version", (QueryProperty)ModelQueryProperty.MODEL_VERSION);
        allowedSortProperties.put("tenantId", (QueryProperty)ModelQueryProperty.MODEL_TENANT_ID);
    }
}

