/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.form;

import org.flowable.app.engine.AppEngine;
import org.flowable.engine.ProcessEngine;
import org.flowable.form.api.FormManagementService;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.FormEngines;
import org.flowable.form.spring.FormEngineFactoryBean;
import org.flowable.form.spring.SpringFormEngineConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnFormEngine;
import org.flowable.spring.boot.form.FlowableFormProperties;
import org.flowable.spring.boot.form.FormEngineAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnFormEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableFormProperties.class})
@AutoConfigureAfter(value={FormEngineAutoConfiguration.class, AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class FormEngineServicesAutoConfiguration {
    @Bean
    public FormService formService(FormEngine formEngine) {
        return formEngine.getFormService();
    }

    @Bean
    public FormRepositoryService formRepositoryService(FormEngine formEngine) {
        return formEngine.getFormRepositoryService();
    }

    @Bean
    public FormManagementService formManagementService(FormEngine formEngine) {
        return formEngine.getFormManagementService();
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.form.engine.FormEngine", "org.flowable.engine.ProcessEngine", "org.flowable.app.engine.AppEngine"})
    static class StandaloneFormEngineConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringFormEngineConfiguration> {
        StandaloneFormEngineConfiguration() {
        }

        @Bean
        public FormEngineFactoryBean formEngine(SpringFormEngineConfiguration formEngineConfiguration) {
            FormEngineFactoryBean factory = new FormEngineFactoryBean();
            factory.setFormEngineConfiguration((FormEngineConfiguration)formEngineConfiguration);
            this.invokeConfigurers(formEngineConfiguration);
            return factory;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.form.engine.FormEngine"})
    @ConditionalOnBean(type={"org.flowable.app.engine.AppEngine"})
    static class AlreadyInitializedAppEngineConfiguration {
        AlreadyInitializedAppEngineConfiguration() {
        }

        @Bean
        public FormEngine formEngine(AppEngine appEngine) {
            if (!FormEngines.isInitialized()) {
                throw new IllegalStateException("Form engine has not been initialized");
            }
            return FormEngines.getDefaultFormEngine();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.form.engine.FormEngine", "org.flowable.app.engine.AppEngine"})
    @ConditionalOnBean(type={"org.flowable.engine.ProcessEngine"})
    static class AlreadyInitializedFormEngineConfiguration {
        AlreadyInitializedFormEngineConfiguration() {
        }

        @Bean
        public FormEngine formEngine(ProcessEngine processEngine) {
            if (!FormEngines.isInitialized()) {
                throw new IllegalStateException("Form engine has not been initialized");
            }
            return FormEngines.getDefaultFormEngine();
        }
    }
}

