/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.cmmn;

import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.cmmn.engine.configurator.CmmnEngineConfigurator;
import org.flowable.cmmn.spring.SpringCmmnEngineConfiguration;
import org.flowable.cmmn.spring.configurator.SpringCmmnEngineConfigurator;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableJobConfiguration;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.FlowableAppProperties;
import org.flowable.spring.boot.cmmn.Cmmn;
import org.flowable.spring.boot.cmmn.FlowableCmmnProperties;
import org.flowable.spring.boot.condition.ConditionalOnCmmnEngine;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.flowable.spring.job.service.SpringAsyncExecutor;
import org.flowable.spring.job.service.SpringRejectedJobsHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnCmmnEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableIdmProperties.class, FlowableCmmnProperties.class, FlowableAppProperties.class})
@AutoConfigureAfter(value={AppEngineAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
@AutoConfigureBefore(value={AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
@Import(value={FlowableJobConfiguration.class})
public class CmmnEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableCmmnProperties cmmnProperties;
    protected final FlowableIdmProperties idmProperties;

    public CmmnEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableCmmnProperties cmmnProperties, FlowableIdmProperties idmProperties) {
        super(flowableProperties);
        this.cmmnProperties = cmmnProperties;
        this.idmProperties = idmProperties;
    }

    @Bean
    @Cmmn
    @ConfigurationProperties(prefix="flowable.cmmn.async.executor")
    @ConditionalOnMissingBean(name={"cmmnAsyncExecutor"})
    public SpringAsyncExecutor cmmnAsyncExecutor(ObjectProvider<TaskExecutor> taskExecutor, @Cmmn ObjectProvider<TaskExecutor> cmmnTaskExecutor, ObjectProvider<SpringRejectedJobsHandler> rejectedJobsHandler, @Cmmn ObjectProvider<SpringRejectedJobsHandler> cmmnRejectedJobsHandler) {
        return new SpringAsyncExecutor(this.getIfAvailable(cmmnTaskExecutor, taskExecutor), this.getIfAvailable(cmmnRejectedJobsHandler, rejectedJobsHandler));
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringCmmnEngineConfiguration cmmnEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, @Cmmn ObjectProvider<AsyncExecutor> asyncExecutorProvider) throws IOException {
        AsyncExecutor asyncExecutor;
        SpringCmmnEngineConfiguration configuration = new SpringCmmnEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.cmmnProperties.getResourceLocation(), this.cmmnProperties.getResourceSuffixes(), this.cmmnProperties.isDeployResources());
        if (resources != null && !resources.isEmpty()) {
            configuration.setDeploymentResources(resources.toArray(new Resource[0]));
            configuration.setDeploymentName(this.cmmnProperties.getDeploymentName());
        }
        if ((asyncExecutor = (AsyncExecutor)asyncExecutorProvider.getIfUnique()) != null) {
            configuration.setAsyncExecutor(asyncExecutor);
        }
        this.configureSpringEngine((SpringEngineConfiguration)configuration, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        configuration.setDeploymentName(this.defaultText(this.cmmnProperties.getDeploymentName(), configuration.getDeploymentName()));
        configuration.setDisableIdmEngine(!this.idmProperties.isEnabled());
        configuration.setAsyncExecutorActivate(this.flowableProperties.isAsyncExecutorActivate());
        configuration.setHistoryLevel(this.flowableProperties.getHistoryLevel());
        configuration.setEnableSafeCmmnXml(this.cmmnProperties.isEnableSafeXml());
        return configuration;
    }

    @Configuration
    @ConditionalOnBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class CmmnEngineAppConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringCmmnEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"cmmnAppEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringAppEngineConfiguration> cmmnAppEngineConfigurationConfigurer(CmmnEngineConfigurator cmmnEngineConfigurator) {
            return appEngineConfiguration -> appEngineConfiguration.addConfigurator((EngineConfigurator)cmmnEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public CmmnEngineConfigurator cmmnEngineConfigurator(SpringCmmnEngineConfiguration cmmnEngineConfiguration) {
            SpringCmmnEngineConfigurator cmmnEngineConfigurator = new SpringCmmnEngineConfigurator();
            cmmnEngineConfigurator.setCmmnEngineConfiguration(cmmnEngineConfiguration);
            cmmnEngineConfiguration.setDisableIdmEngine(true);
            this.invokeConfigurers(cmmnEngineConfiguration);
            return cmmnEngineConfigurator;
        }
    }

    @Configuration
    @ConditionalOnBean(type={"org.flowable.spring.SpringProcessEngineConfiguration"})
    @ConditionalOnMissingBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class CmmnEngineProcessConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringCmmnEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"cmmnProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> cmmnProcessEngineConfigurationConfigurer(CmmnEngineConfigurator cmmnEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.addConfigurator((EngineConfigurator)cmmnEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public CmmnEngineConfigurator cmmnEngineConfigurator(SpringCmmnEngineConfiguration cmmnEngineConfiguration) {
            SpringCmmnEngineConfigurator cmmnEngineConfigurator = new SpringCmmnEngineConfigurator();
            cmmnEngineConfigurator.setCmmnEngineConfiguration(cmmnEngineConfiguration);
            cmmnEngineConfiguration.setDisableIdmEngine(true);
            this.invokeConfigurers(cmmnEngineConfiguration);
            return cmmnEngineConfigurator;
        }
    }
}

