/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.environment;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=100)
public class FlowableLiquibaseEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableLiquibaseEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String liquibaseProperty = this.getLiquibaseProperty();
        if (!environment.containsProperty(liquibaseProperty)) {
            LOGGER.warn("Liquibase has not been explicitly enabled or disabled. Overriding default from Spring Boot from `true` to `false`. Flowable pulls in Liquibase, but does not use the Spring Boot configuration for it. If you are using it you would need to set `{}` to `true` by yourself", (Object)liquibaseProperty);
            HashMap<String, Boolean> source = new HashMap<String, Boolean>();
            source.put(liquibaseProperty, false);
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource("flowable-liquibase-override", source));
        }
    }

    protected String getLiquibaseProperty() {
        String liquibaseProperty = "liquibase.enabled";
        String springBootVersion = SpringBootVersion.getVersion();
        if (springBootVersion.startsWith("2")) {
            liquibaseProperty = "spring." + liquibaseProperty;
        }
        return liquibaseProperty;
    }
}

