/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.app;

import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.persistence.StrongUuidGenerator;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.app.FlowableAppProperties;
import org.flowable.spring.boot.condition.ConditionalOnAppEngine;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnAppEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableAppProperties.class, FlowableIdmProperties.class})
public class AppEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableAppProperties appProperties;
    protected final FlowableIdmProperties idmProperties;

    public AppEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableAppProperties appProperties, FlowableIdmProperties idmProperties) {
        super(flowableProperties);
        this.appProperties = appProperties;
        this.idmProperties = idmProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringAppEngineConfiguration springAppEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager) throws IOException {
        SpringAppEngineConfiguration conf = new SpringAppEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.appProperties.getResourceLocation(), this.appProperties.getResourceSuffixes(), this.appProperties.isDeployResources());
        if (resources != null && !resources.isEmpty()) {
            conf.setDeploymentResources(resources.toArray(new Resource[0]));
        }
        this.configureSpringEngine((SpringEngineConfiguration)conf, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)conf, dataSource);
        conf.setIdGenerator((IdGenerator)new StrongUuidGenerator());
        return conf;
    }
}

