/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.rest;

import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.flowable.spring.boot.FlowableServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class BaseRestApiConfiguration
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;
    protected MultipartConfigElement multipartConfigElement;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected ServletRegistrationBean registerServlet(FlowableServlet servletProperties, Class<?> baseConfig) {
        AnnotationConfigWebApplicationContext dispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        dispatcherServletConfiguration.setParent(this.applicationContext);
        dispatcherServletConfiguration.register(new Class[]{baseConfig});
        DispatcherServlet servlet = new DispatcherServlet((WebApplicationContext)dispatcherServletConfiguration);
        String path = servletProperties.getPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, new String[]{urlMapping});
        registrationBean.setName(servletProperties.getName());
        registrationBean.setLoadOnStartup(servletProperties.getLoadOnStartup());
        registrationBean.setAsyncSupported(true);
        if (this.multipartConfigElement != null) {
            registrationBean.setMultipartConfig(this.multipartConfigElement);
        }
        return registrationBean;
    }

    @Autowired(required=false)
    public void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }
}

