/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.liquibase;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class LiquibaseXmlElementClassNotFoundFailureAnalyzer
extends AbstractFailureAnalyzer<ClassNotFoundException> {
    protected FailureAnalysis analyze(Throwable rootFailure, ClassNotFoundException cause) {
        String causeMessage = cause.getMessage();
        if (causeMessage != null && causeMessage.contains("javax.xml.bind.annotation.XmlElement")) {
            for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
                if (!stackTraceElement.getClassName().startsWith("liquibase.pro.packaged")) continue;
                return new FailureAnalysis("Liquibase failed to initialize due to javax.xml.bin.annotation.XmlElement not being present. Liquibase Versions starting from 3.8.1 have problems on Java 11. See https://liquibase.jira.com/browse/CORE-3537 for more information.", "Set the liquibase version to 3.8.0", (Throwable)cause);
            }
        }
        return null;
    }
}

