/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.spring.boot.FlowableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

public abstract class AbstractEngineAutoConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FlowableProperties flowableProperties;
    protected ResourcePatternResolver resourcePatternResolver;

    public AbstractEngineAutoConfiguration(FlowableProperties flowableProperties) {
        this.flowableProperties = flowableProperties;
    }

    @Autowired
    public void setResourcePatternResolver(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    protected void configureEngine(AbstractEngineConfiguration engineConfiguration, DataSource dataSource) {
        engineConfiguration.setDataSource(dataSource);
        engineConfiguration.setDatabaseSchema(this.defaultText(this.flowableProperties.getDatabaseSchema(), engineConfiguration.getDatabaseSchema()));
        engineConfiguration.setDatabaseSchemaUpdate(this.defaultText(this.flowableProperties.getDatabaseSchemaUpdate(), engineConfiguration.getDatabaseSchemaUpdate()));
        engineConfiguration.setUseLockForDatabaseSchemaUpdate(this.flowableProperties.isUseLockForDatabaseSchemaUpdate());
        engineConfiguration.setDbHistoryUsed(this.flowableProperties.isDbHistoryUsed());
        if (this.flowableProperties.getCustomMybatisMappers() != null) {
            engineConfiguration.setCustomMybatisMappers(this.getCustomMybatisMapperClasses(this.flowableProperties.getCustomMybatisMappers()));
        }
        if (this.flowableProperties.getCustomMybatisXMLMappers() != null) {
            engineConfiguration.setCustomMybatisXMLMappers(new HashSet<String>(this.flowableProperties.getCustomMybatisXMLMappers()));
        }
        if (this.flowableProperties.getCustomMybatisMappers() != null) {
            engineConfiguration.setCustomMybatisMappers(this.getCustomMybatisMapperClasses(this.flowableProperties.getCustomMybatisMappers()));
        }
        if (this.flowableProperties.getCustomMybatisXMLMappers() != null) {
            engineConfiguration.setCustomMybatisXMLMappers(new HashSet<String>(this.flowableProperties.getCustomMybatisXMLMappers()));
        }
        if (this.flowableProperties.getLockPollRate() != null) {
            engineConfiguration.setLockPollRate(this.flowableProperties.getLockPollRate());
        }
        if (this.flowableProperties.getSchemaLockWaitTime() != null) {
            engineConfiguration.setSchemaLockWaitTime(this.flowableProperties.getSchemaLockWaitTime());
        }
    }

    public List<Resource> discoverDeploymentResources(String prefix, List<String> suffixes, boolean loadResources) throws IOException {
        if (loadResources) {
            ArrayList<Resource> result = new ArrayList<Resource>();
            for (String suffix : suffixes) {
                String path = prefix + suffix;
                Resource[] resources = this.resourcePatternResolver.getResources(path);
                if (resources == null || resources.length <= 0) continue;
                Collections.addAll(result, resources);
            }
            if (result.isEmpty()) {
                this.logger.info("No deployment resources were found for autodeployment");
            }
            return result;
        }
        return new ArrayList<Resource>();
    }

    protected Set<Class<?>> getCustomMybatisMapperClasses(List<String> customMyBatisMappers) {
        HashSet mybatisMappers = new HashSet();
        for (String customMybatisMapperClassName : customMyBatisMappers) {
            try {
                Class<?> customMybatisClass = Class.forName(customMybatisMapperClassName);
                mybatisMappers.add(customMybatisClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class " + customMybatisMapperClassName + " has not been found.", e);
            }
        }
        return mybatisMappers;
    }

    protected String defaultText(String deploymentName, String defaultName) {
        if (StringUtils.hasText((String)deploymentName)) {
            return deploymentName;
        }
        return defaultName;
    }
}

