/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.spring.ProcessEngineFactoryBean;
import org.flowable.spring.SpringAsyncExecutor;
import org.flowable.spring.SpringCallerRunsRejectedJobsHandler;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.SpringRejectedJobsHandler;
import org.flowable.spring.boot.AbstractProcessEngineConfiguration;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineConfigurationConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

public abstract class AbstractProcessEngineAutoConfiguration
extends AbstractProcessEngineConfiguration {
    protected FlowableProperties flowableProperties;
    @Autowired
    private ResourcePatternResolver resourceLoader;
    @Autowired(required=false)
    private ProcessEngineConfigurationConfigurer processEngineConfigurationConfigurer;

    @Bean
    public SpringAsyncExecutor springAsyncExecutor(TaskExecutor taskExecutor) {
        return new SpringAsyncExecutor(taskExecutor, this.springRejectedJobsHandler());
    }

    @Bean
    public SpringRejectedJobsHandler springRejectedJobsHandler() {
        return new SpringCallerRunsRejectedJobsHandler();
    }

    protected SpringProcessEngineConfiguration baseSpringProcessEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, SpringAsyncExecutor springAsyncExecutor) throws IOException {
        List<Resource> procDefResources = this.discoverProcessDefinitionResources(this.resourceLoader, this.flowableProperties.getProcessDefinitionLocationPrefix(), this.flowableProperties.getProcessDefinitionLocationSuffixes(), this.flowableProperties.isCheckProcessDefinitions());
        SpringProcessEngineConfiguration conf = super.processEngineConfigurationBean(procDefResources.toArray(new Resource[procDefResources.size()]), dataSource, platformTransactionManager, springAsyncExecutor);
        conf.setDeploymentName(this.defaultText(this.flowableProperties.getDeploymentName(), conf.getDeploymentName()));
        conf.setDatabaseSchema(this.defaultText(this.flowableProperties.getDatabaseSchema(), conf.getDatabaseSchema()));
        conf.setDatabaseSchemaUpdate(this.defaultText(this.flowableProperties.getDatabaseSchemaUpdate(), conf.getDatabaseSchemaUpdate()));
        conf.setDbHistoryUsed(this.flowableProperties.isDbHistoryUsed());
        conf.setAsyncExecutorActivate(this.flowableProperties.isAsyncExecutorActivate());
        conf.setMailServerHost(this.flowableProperties.getMailServerHost());
        conf.setMailServerPort(this.flowableProperties.getMailServerPort());
        conf.setMailServerUsername(this.flowableProperties.getMailServerUserName());
        conf.setMailServerPassword(this.flowableProperties.getMailServerPassword());
        conf.setMailServerDefaultFrom(this.flowableProperties.getMailServerDefaultFrom());
        conf.setMailServerUseSSL(this.flowableProperties.isMailServerUseSsl());
        conf.setMailServerUseTLS(this.flowableProperties.isMailServerUseTls());
        conf.setHistoryLevel(this.flowableProperties.getHistoryLevel());
        if (this.flowableProperties.getCustomMybatisMappers() != null) {
            conf.setCustomMybatisMappers(this.getCustomMybatisMapperClasses(this.flowableProperties.getCustomMybatisMappers()));
        }
        if (this.flowableProperties.getCustomMybatisXMLMappers() != null) {
            conf.setCustomMybatisXMLMappers(new HashSet<String>(this.flowableProperties.getCustomMybatisXMLMappers()));
        }
        if (this.flowableProperties.getCustomMybatisMappers() != null) {
            conf.setCustomMybatisMappers(this.getCustomMybatisMapperClasses(this.flowableProperties.getCustomMybatisMappers()));
        }
        if (this.flowableProperties.getCustomMybatisXMLMappers() != null) {
            conf.setCustomMybatisXMLMappers(new HashSet<String>(this.flowableProperties.getCustomMybatisXMLMappers()));
        }
        if (this.processEngineConfigurationConfigurer != null) {
            this.processEngineConfigurationConfigurer.configure(conf);
        }
        return conf;
    }

    protected Set<Class<?>> getCustomMybatisMapperClasses(List<String> customMyBatisMappers) {
        HashSet mybatisMappers = new HashSet();
        for (String customMybatisMapperClassName : customMyBatisMappers) {
            try {
                Class<?> customMybatisClass = Class.forName(customMybatisMapperClassName);
                mybatisMappers.add(customMybatisClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class " + customMybatisMapperClassName + " has not been found.", e);
            }
        }
        return mybatisMappers;
    }

    protected String defaultText(String deploymentName, String deploymentName1) {
        if (StringUtils.hasText((String)deploymentName)) {
            return deploymentName;
        }
        return deploymentName1;
    }

    @Autowired
    protected void setFlowableProperties(FlowableProperties flowableProperties) {
        this.flowableProperties = flowableProperties;
    }

    protected FlowableProperties getFlowableProperties() {
        return this.flowableProperties;
    }

    @Bean
    public ProcessEngineFactoryBean processEngine(SpringProcessEngineConfiguration configuration) throws Exception {
        return super.springProcessEngineBean(configuration);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public RuntimeService runtimeServiceBean(ProcessEngine processEngine) {
        return super.runtimeServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public RepositoryService repositoryServiceBean(ProcessEngine processEngine) {
        return super.repositoryServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public TaskService taskServiceBean(ProcessEngine processEngine) {
        return super.taskServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public HistoryService historyServiceBean(ProcessEngine processEngine) {
        return super.historyServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public ManagementService managementServiceBeanBean(ProcessEngine processEngine) {
        return super.managementServiceBeanBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public FormService formServiceBean(ProcessEngine processEngine) {
        return super.formServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public IdentityService identityServiceBean(ProcessEngine processEngine) {
        return super.identityServiceBean(processEngine);
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskExecutor taskExecutor() {
        return new SimpleAsyncTaskExecutor();
    }
}

