/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.common.impl.persistence.deploy.DefaultDeploymentCache;
import org.flowable.engine.common.impl.persistence.deploy.DeploymentCache;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.flowable")
public class ProcessEngineEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private final ProcessEngine processEngine;

    public ProcessEngineEndpoint(ProcessEngine processEngine) {
        super("flowable");
        this.processEngine = processEngine;
    }

    public Map<String, Object> invoke() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("processDefinitionCount", this.processEngine.getRepositoryService().createProcessDefinitionQuery().count());
        List processDefinitions = ((ProcessDefinitionQuery)this.processEngine.getRepositoryService().createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).list();
        ArrayList<String> processDefinitionKeys = new ArrayList<String>();
        for (Object processDefinition : processDefinitions) {
            processDefinitionKeys.add(processDefinition.getKey() + " (v" + processDefinition.getVersion() + ")");
        }
        metrics.put("deployedProcessDefinitions", processDefinitionKeys);
        HashMap<String, Long> processInstanceCountMap = new HashMap<String, Long>();
        metrics.put("runningProcessInstanceCount", processInstanceCountMap);
        for (Object processDefinition : processDefinitions) {
            processInstanceCountMap.put(processDefinition.getKey() + " (v" + processDefinition.getVersion() + ")", this.processEngine.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).count());
        }
        HashMap<String, Long> completedProcessInstanceCountMap = new HashMap<String, Long>();
        metrics.put("completedProcessInstanceCount", completedProcessInstanceCountMap);
        for (ProcessDefinition processDefinition : processDefinitions) {
            completedProcessInstanceCountMap.put(processDefinition.getKey() + " (v" + processDefinition.getVersion() + ")", this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().finished().processDefinitionId(processDefinition.getId()).count());
        }
        metrics.put("openTaskCount", this.processEngine.getTaskService().createTaskQuery().count());
        metrics.put("completedTaskCount", this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().finished().count());
        metrics.put("completedTaskCountToday", this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().finished().taskCompletedAfter(new Date(System.currentTimeMillis() - this.secondsForDays(1))).count());
        metrics.put("completedActivities", this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().finished().count());
        DeploymentCache deploymentCache = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getProcessDefinitionCache();
        if (deploymentCache instanceof DefaultDeploymentCache) {
            metrics.put("cachedProcessDefinitionCount", ((DefaultDeploymentCache)deploymentCache).size());
        }
        return metrics;
    }

    private long secondsForDays(int days) {
        int hour = 3600000;
        int day = 24 * hour;
        return days * day;
    }
}

