/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.spring;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;

public abstract class CommonAutoDeploymentStrategy<E>
implements AutoDeploymentStrategy<E> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected CommonAutoDeploymentProperties deploymentProperties;

    public CommonAutoDeploymentStrategy() {
        this(new CommonAutoDeploymentProperties(false, Duration.ofMinutes(5L), true));
    }

    public CommonAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    protected abstract String getDeploymentMode();

    protected abstract LockManager getLockManager(E var1, String var2);

    protected String determineLockName(String deploymentNameHint) {
        String lockName = this.getLockName();
        if (StringUtils.isBlank((CharSequence)lockName)) {
            return deploymentNameHint;
        }
        return lockName;
    }

    @Override
    public boolean handlesMode(String mode) {
        return StringUtils.equalsIgnoreCase((CharSequence)mode, (CharSequence)this.getDeploymentMode());
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, E engine) {
        if (this.isUseLockForDeployments()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Deploying resources {} using a lock for engine {} deployment name hint {}", new Object[]{Arrays.toString(resources), engine, deploymentNameHint});
            }
            LockManager deploymentLockManager = this.getLockManager(engine, deploymentNameHint);
            deploymentLockManager.waitForLockRunAndRelease(this.getDeploymentLockWaitTime(), () -> {
                this.deployResourcesInternal(deploymentNameHint, resources, engine);
                return null;
            });
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Deploying resources {} for engine {} deployment name hint {}", new Object[]{Arrays.toString(resources), engine, deploymentNameHint});
            }
            this.deployResourcesInternal(deploymentNameHint, resources, engine);
        }
    }

    protected abstract void deployResourcesInternal(String var1, Resource[] var2, E var3);

    protected String determineResourceName(Resource resource) {
        String resourceName = null;
        if (resource instanceof ContextResource) {
            resourceName = ((ContextResource)resource).getPathWithinContext();
        } else if (resource instanceof ByteArrayResource) {
            resourceName = resource.getDescription();
        } else {
            try {
                resourceName = resource.getFile().getAbsolutePath();
            }
            catch (IOException e) {
                resourceName = resource.getFilename();
            }
        }
        return resourceName;
    }

    public CommonAutoDeploymentProperties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public void setDeploymentProperties(CommonAutoDeploymentProperties deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    public boolean isUseLockForDeployments() {
        return this.deploymentProperties.isUseLock();
    }

    public Duration getDeploymentLockWaitTime() {
        return this.deploymentProperties.getLockWaitTime();
    }

    public boolean isThrowExceptionOnDeploymentFailure() {
        return this.deploymentProperties.isThrowExceptionOnDeploymentFailure();
    }

    public String getLockName() {
        return this.deploymentProperties.getLockName();
    }
}

