/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.spring.configurator;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.configurator.ProcessEngineConfigurator;
import org.flowable.spring.SpringExpressionManager;
import org.flowable.spring.SpringProcessEngineConfiguration;

public class SpringProcessEngineConfigurator
extends ProcessEngineConfigurator {
    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.processEngineConfiguration == null) {
            this.processEngineConfiguration = new SpringProcessEngineConfiguration();
        }
        if (!(this.processEngineConfiguration instanceof SpringProcessEngineConfiguration)) {
            throw new FlowableException("SpringProcessEngineConfigurator accepts only SpringProcessEngineConfiguration. " + this.processEngineConfiguration.getClass().getName());
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.processEngineConfiguration);
        SpringEngineConfiguration springEngineConfiguration = (SpringEngineConfiguration)engineConfiguration;
        SpringProcessEngineConfiguration springProcessEngineConfiguration = (SpringProcessEngineConfiguration)this.processEngineConfiguration;
        springProcessEngineConfiguration.setTransactionManager(springEngineConfiguration.getTransactionManager());
        springProcessEngineConfiguration.setExpressionManager((ExpressionManager)new SpringExpressionManager(springEngineConfiguration.getApplicationContext(), springEngineConfiguration.getBeans()));
        this.initProcessEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.processEngineConfiguration);
    }

    protected synchronized ProcessEngine initProcessEngine() {
        if (this.processEngineConfiguration == null) {
            throw new FlowableException("ProcessEngineConfiguration is required");
        }
        return this.processEngineConfiguration.buildProcessEngine();
    }

    public SpringProcessEngineConfiguration getProcessEngineConfiguration() {
        return (SpringProcessEngineConfiguration)this.processEngineConfiguration;
    }

    public SpringProcessEngineConfigurator setProcessEngineConfiguration(SpringProcessEngineConfiguration processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        return this;
    }
}

