/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class DbScriptUtil {
    public static void main(String ... args) throws Exception {
        DbScriptUtil.dropSchema();
    }

    public static void dropSchema() throws Exception {
        System.out.println("Dropping schema");
        DatabaseConnection databaseConnection = DbScriptUtil.createDbConnection();
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(databaseConnection);
        Liquibase liquibase = new Liquibase("META-INF/liquibase/db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.dropAll();
        DbScriptUtil.closeDatabase(database, databaseConnection);
    }

    protected static DatabaseConnection createDbConnection() throws Exception {
        Properties properties = new Properties();
        properties.load(DbScriptUtil.class.getClassLoader().getResourceAsStream("META-INF/flowable-admin/TEST-db.properties"));
        Connection connection = DriverManager.getConnection(properties.getProperty("spring.datasource.url"), properties.getProperty("spring.datasource.username"), properties.getProperty("spring.datasource.password"));
        JdbcConnection databaseConnection = new JdbcConnection(connection);
        return databaseConnection;
    }

    protected static void closeDatabase(Database database, DatabaseConnection databaseConnection) {
        try {
            database.close();
            databaseConnection.close();
        }
        catch (Exception e) {
            System.out.println("Error closing db connection " + e.getMessage());
        }
    }
}

