/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeploymentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentService.class);
    @Autowired
    protected FlowableClientService clientUtil;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonNode listDeployments(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = null;
        try {
            builder = new URIBuilder("repository/deployments");
        }
        catch (Exception e) {
            LOGGER.error("Error building uri", (Throwable)e);
            throw new FlowableServiceException("Error building uri", e);
        }
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getDeployment(ServerConfig serverConfig, String deploymentId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "repository/deployments/" + deploymentId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode uploadDeployment(ServerConfig serverConfig, String name, InputStream inputStream) throws IOException {
        JsonNode appDefinitionJson;
        String deploymentKey = null;
        String deploymentName = null;
        byte[] inputStreamByteArray = IOUtils.toByteArray((InputStream)inputStream);
        if (name != null && (name.endsWith(".zip") || name.endsWith(".bar")) && (appDefinitionJson = this.getAppDefinitionJson(new ByteArrayInputStream(inputStreamByteArray))) != null) {
            if (appDefinitionJson.has("key") && appDefinitionJson.get("key") != null) {
                deploymentKey = appDefinitionJson.get("key").asText();
            }
            if (appDefinitionJson.has("name") && appDefinitionJson.get("name") != null) {
                deploymentName = appDefinitionJson.get("name").asText();
            }
        }
        URIBuilder uriBuilder = this.clientUtil.createUriBuilder("repository/deployments");
        if (StringUtils.isNotEmpty(deploymentKey)) {
            uriBuilder.addParameter("deploymentKey", this.encode(deploymentKey));
        }
        if (StringUtils.isNotEmpty(deploymentName)) {
            uriBuilder.addParameter("deploymentName", this.encode(deploymentName));
        }
        HttpPost post = new HttpPost(this.clientUtil.getServerUrl(serverConfig, uriBuilder));
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody(name, inputStreamByteArray, ContentType.APPLICATION_OCTET_STREAM, name).build();
        post.setEntity(reqEntity);
        return this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig, 201);
    }

    public void deleteDeployment(ServerConfig serverConfig, HttpServletResponse httpResponse, String appDeploymentId) {
        HttpDelete delete = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, this.clientUtil.createUriBuilder("repository/deployments/" + appDeploymentId)));
        this.clientUtil.execute((HttpUriRequest)delete, httpResponse, serverConfig);
    }

    protected JsonNode getAppDefinitionJson(ByteArrayInputStream bais) throws IOException {
        ZipEntry entry;
        ZipInputStream zipIS = new ZipInputStream(bais);
        JsonNode appDefinitionJson = null;
        while ((entry = zipIS.getNextEntry()) != null) {
            if (entry.getName() == null || !entry.getName().endsWith(".app")) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipIS));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            String json = js.toString();
            appDefinitionJson = this.objectMapper.readTree(json);
            reader.close();
            break;
        }
        zipIS.close();
        return appDefinitionJson;
    }

    protected String encode(String string) {
        if (string != null) {
            try {
                return URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException("JVM does not support UTF-8 encoding.", uee);
            }
        }
        return null;
    }
}

