/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionService.class);
    @Autowired
    protected FlowableClientService clientUtil;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonNode listProcesDefinitions(ServerConfig serverConfig, Map<String, String[]> parameterMap, boolean latest) {
        URIBuilder builder = null;
        try {
            builder = new URIBuilder("repository/process-definitions");
        }
        catch (Exception e) {
            LOGGER.error("Error building uri", (Throwable)e);
            throw new FlowableServiceException("Error building uri", e);
        }
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getProcessDefinition(ServerConfig serverConfig, String definitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "repository/process-definitions/" + definitionId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode updateProcessDefinitionCategory(ServerConfig serverConfig, String definitionId, String category) {
        ObjectNode updateCall = this.objectMapper.createObjectNode();
        updateCall.put("category", category);
        URIBuilder builder = this.clientUtil.createUriBuilder("repository/process-definitions/" + definitionId);
        HttpPut put = this.clientUtil.createPut(builder, serverConfig);
        put.setEntity((HttpEntity)this.clientUtil.createStringEntity((JsonNode)updateCall));
        return this.clientUtil.executeRequest((HttpUriRequest)put, serverConfig);
    }

    public BpmnModel getProcessDefinitionModel(ServerConfig serverConfig, String definitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "repository/process-definitions/" + definitionId + "/resourcedata"));
        return this.executeRequestForXML((HttpUriRequest)get, serverConfig, 200);
    }

    public void migrateInstancesOfProcessDefinition(ServerConfig serverConfig, String processDefinitionId, String migrationDocument) throws FlowableServiceException {
        try {
            URIBuilder builder = this.clientUtil.createUriBuilder("repository/process-definitions/" + processDefinitionId + "/batch-migrate");
            HttpPost post = this.clientUtil.createPost(builder.build().toString(), serverConfig);
            post.setEntity((HttpEntity)this.clientUtil.createStringEntity(migrationDocument));
            this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)post, serverConfig, 200);
        }
        catch (Exception e) {
            throw new FlowableServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BpmnModel executeRequestForXML(HttpUriRequest request, ServerConfig serverConfig, int expectedStatusCode) {
        Throwable throwable;
        CloseableHttpResponse response;
        FlowableServiceException exception;
        block31: {
            BpmnModel bpmnModel;
            CloseableHttpClient client;
            block32: {
                block33: {
                    boolean success;
                    exception = null;
                    client = this.clientUtil.getHttpClient(serverConfig);
                    response = client.execute(request);
                    throwable = null;
                    InputStream responseContent = response.getEntity().getContent();
                    XMLInputFactory xif = XMLInputFactory.newInstance();
                    InputStreamReader in = new InputStreamReader(responseContent, StandardCharsets.UTF_8);
                    XMLStreamReader xtr = xif.createXMLStreamReader(in);
                    BpmnModel bpmnModel2 = new BpmnXMLConverter().convertToBpmnModel(xtr);
                    boolean bl = success = response.getStatusLine() != null && response.getStatusLine().getStatusCode() == expectedStatusCode;
                    if (!success) break block31;
                    bpmnModel = bpmnModel2;
                    if (response == null) break block32;
                    if (throwable == null) break block33;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block32;
                }
                response.close();
            }
            try {
                client.close();
                return bpmnModel;
            }
            catch (Exception e) {
                LOGGER.warn("Error closing http client instance", (Throwable)e);
            }
            return bpmnModel;
        }
        try {
            try {
                exception = new FlowableServiceException("An error occurred while calling Flowable: " + response.getStatusLine());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
            exception = this.clientUtil.wrapException(e, request);
        }
        if (exception == null) return null;
        throw exception;
    }
}

