/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.DecisionTableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DecisionTablesClientResource
extends AbstractClientResource {
    @Autowired
    protected DecisionTableService clientService;

    @GetMapping(value={"/rest/admin/decision-tables"}, produces={"application/json"})
    public JsonNode listDecisionTables(HttpServletRequest request) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.DMN);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        return this.clientService.listDecisionTables(serverConfig, parameterMap);
    }

    @GetMapping(value={"/rest/admin/process-definition-decision-tables/{processDefinitionId}"}, produces={"application/json"})
    public JsonNode getProcessDefinitionDecisionTables(@PathVariable String processDefinitionId, HttpServletRequest request) {
        return this.clientService.getProcessDefinitionDecisionTables(this.retrieveServerConfig(EndpointType.PROCESS), processDefinitionId);
    }

    @GetMapping(value={"/rest/admin/case-definition-decision-tables/{caseDefinitionId}"}, produces={"application/json"})
    public JsonNode getCaseDefinitionDecisionTables(@PathVariable String caseDefinitionId, HttpServletRequest request) {
        return this.clientService.getCaseDefinitionDecisionTables(this.retrieveServerConfig(EndpointType.CMMN), caseDefinitionId);
    }
}

