/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import javax.servlet.http.HttpServletResponse;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.FormDeploymentService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormDeploymentClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDeploymentClientResource.class);
    @Autowired
    protected FormDeploymentService clientService;

    @GetMapping(value={"/rest/admin/form-deployments/{deploymentId}"}, produces={"application/json"})
    public JsonNode getDeployment(@PathVariable String deploymentId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        try {
            return this.clientService.getDeployment(serverConfig, deploymentId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting form deployment {}", (Object)deploymentId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @DeleteMapping(value={"/rest/admin/form-deployments/{deploymentId}"})
    public void deleteDeployment(@PathVariable String deploymentId, HttpServletResponse httpResponse) {
        this.clientService.deleteDeployment(this.retrieveServerConfig(EndpointType.FORM), httpResponse, deploymentId);
    }
}

