/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.FormDefinitionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormDefinitionsClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDefinitionsClientResource.class);
    @Autowired
    protected FormDefinitionService clientService;

    @GetMapping(value={"/rest/admin/form-definitions"}, produces={"application/json"})
    public JsonNode listFormDefinitions(HttpServletRequest request) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        return this.clientService.listForms(serverConfig, parameterMap);
    }

    @GetMapping(value={"/rest/admin/process-definition-form-definitions/{processDefinitionId}"}, produces={"application/json"})
    public JsonNode getProcessDefinitionForms(@PathVariable String processDefinitionId, HttpServletRequest request) {
        return this.clientService.getProcessDefinitionForms(this.retrieveServerConfig(EndpointType.PROCESS), processDefinitionId);
    }

    @GetMapping(value={"/rest/admin/case-definition-form-definitions/{processDefinitionId}"}, produces={"application/json"})
    public JsonNode getCaseDefinitionForms(@PathVariable String processDefinitionId, HttpServletRequest request) {
        return this.clientService.getCaseDefinitionForms(this.retrieveServerConfig(EndpointType.CMMN), processDefinitionId);
    }
}

