/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.filter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.ui.common.filter.FlowableCookieFilterCallback;
import org.flowable.ui.common.model.RemoteToken;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.security.FlowableAppUser;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class FlowableCookieFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCookieFilter.class);
    protected static final String DELIMITER = ":";
    protected final RemoteIdmService remoteIdmService;
    protected final FlowableCommonAppProperties properties;
    protected FlowableCookieFilterCallback filterCallback;
    protected String idmAppUrl;
    protected String redirectUrlOnAuthSuccess;
    protected Collection<String> requiredPrivileges;
    protected LoadingCache<String, RemoteToken> tokenCache;
    protected LoadingCache<String, FlowableAppUser> userCache;

    public FlowableCookieFilter(RemoteIdmService remoteIdmService, FlowableCommonAppProperties properties) {
        this.remoteIdmService = remoteIdmService;
        this.properties = properties;
    }

    @PostConstruct
    protected void initCaches() {
        this.initIdmAppRedirectUrl();
        this.initTokenCache();
        this.initUserCache();
    }

    protected void initIdmAppRedirectUrl() {
        this.idmAppUrl = this.properties.determineIdmAppRedirectUrl();
        this.redirectUrlOnAuthSuccess = this.properties.getRedirectOnAuthSuccess();
    }

    protected void initTokenCache() {
        FlowableCommonAppProperties.Cache cache = this.properties.getCacheLoginTokens();
        Long maxSize = cache.getMaxSize();
        Long maxAge = cache.getMaxAge();
        this.tokenCache = CacheBuilder.newBuilder().maximumSize(maxSize.longValue()).expireAfterWrite(maxAge.longValue(), TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, RemoteToken>(){

            public RemoteToken load(String tokenId) throws Exception {
                RemoteToken token = FlowableCookieFilter.this.remoteIdmService.getToken(tokenId);
                if (token != null) {
                    return token;
                }
                throw new FlowableException("token not found " + tokenId);
            }
        });
    }

    protected void initUserCache() {
        FlowableCommonAppProperties.Cache cache = this.properties.getCacheLoginUsers();
        Long userMaxSize = cache.getMaxSize();
        Long userMaxAge = cache.getMaxAge();
        this.userCache = CacheBuilder.newBuilder().maximumSize(userMaxSize.longValue()).expireAfterWrite(userMaxAge.longValue(), TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, FlowableAppUser>(){

            public FlowableAppUser load(String userId) throws Exception {
                RemoteUser user = FlowableCookieFilter.this.remoteIdmService.getUser(userId);
                if (user == null) {
                    throw new FlowableException("user not found " + userId);
                }
                ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
                for (String privilege : user.getPrivileges()) {
                    grantedAuthorities.add(new SimpleGrantedAuthority(privilege));
                }
                FlowableAppUser appUser = new FlowableAppUser(user, user.getId(), grantedAuthorities);
                return appUser;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.skipAuthenticationCheck(request)) {
            RemoteToken token = this.getValidToken(request);
            if (token != null) {
                try {
                    FlowableAppUser appUser = (FlowableAppUser)((Object)this.userCache.get((Object)token.getUserId()));
                    if (!this.validateRequiredPriviliges(request, response, appUser)) {
                        this.redirectOrSendNotPermitted(request, response, appUser.getUserObject().getId());
                        return;
                    }
                    SecurityContextHolder.getContext().setAuthentication((Authentication)new RememberMeAuthenticationToken(token.getId(), (Object)appUser, appUser.getAuthorities()));
                }
                catch (Exception e) {
                    LOGGER.trace("Could not set necessary threadlocals for token", (Throwable)e);
                    this.redirectOrSendNotPermitted(request, response, token.getUserId());
                }
                if (this.filterCallback != null) {
                    this.filterCallback.onValidTokenFound(request, response, token);
                }
            } else {
                this.redirectOrSendNotPermitted(request, response, null);
                return;
            }
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (this.filterCallback != null) {
                this.filterCallback.onFilterCleanup(request, response);
            }
        }
    }

    protected RemoteToken getValidToken(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"FLOWABLE_REMEMBER_ME".equals(cookie.getName())) continue;
                String[] tokens = this.decodeCookie(cookie.getValue());
                try {
                    RemoteToken token = (RemoteToken)this.tokenCache.get((Object)tokens[0]);
                    if (!token.getValue().equals(tokens[1])) {
                        this.tokenCache.invalidate((Object)tokens[0]);
                        token = (RemoteToken)this.tokenCache.get((Object)tokens[0]);
                        if (token.getValue().equals(tokens[1])) {
                            return token;
                        }
                        break;
                    }
                    return token;
                }
                catch (Exception e) {
                    LOGGER.trace("Could not get token", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    protected boolean validateRequiredPriviliges(HttpServletRequest request, HttpServletResponse response, FlowableAppUser user) {
        if (user == null) {
            return true;
        }
        String pathInfo = request.getPathInfo();
        if ((this.isRootPath(request) || !pathInfo.startsWith("/rest")) && this.requiredPrivileges != null && this.requiredPrivileges.size() > 0) {
            if (user.getAuthorities() == null || user.getAuthorities().size() == 0) {
                return false;
            }
            int matchingPrivileges = 0;
            for (GrantedAuthority authority : user.getAuthorities()) {
                if (!this.requiredPrivileges.contains(authority.getAuthority())) continue;
                ++matchingPrivileges;
            }
            if (matchingPrivileges != this.requiredPrivileges.size()) {
                return false;
            }
        }
        return true;
    }

    protected void redirectOrSendNotPermitted(HttpServletRequest request, HttpServletResponse response, String userId) {
        if (this.isRootPath(request)) {
            this.redirectToLogin(request, response, userId);
        } else {
            this.sendNotPermitted(request, response);
        }
    }

    protected void redirectToLogin(HttpServletRequest request, HttpServletResponse response, String userId) {
        try {
            if (userId != null) {
                this.userCache.invalidate((Object)userId);
            }
            String baseRedirectUrl = this.idmAppUrl + "#/login?redirectOnAuthSuccess=true&redirectUrl=";
            if (this.redirectUrlOnAuthSuccess != null) {
                response.sendRedirect(baseRedirectUrl + this.redirectUrlOnAuthSuccess);
            } else {
                response.sendRedirect(baseRedirectUrl + request.getRequestURL());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not redirect to {}", (Object)this.idmAppUrl, (Object)e);
        }
    }

    protected void sendNotPermitted(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(403);
    }

    protected boolean isRootPath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return pathInfo == null || "".equals(pathInfo) || "/".equals(pathInfo);
    }

    protected boolean skipAuthenticationCheck(HttpServletRequest request) {
        return request.getRequestURI().endsWith(".css") || request.getRequestURI().endsWith(".js") || request.getRequestURI().endsWith(".html") || request.getRequestURI().endsWith(".map") || request.getRequestURI().endsWith(".woff") || request.getRequestURI().endsWith(".png") || request.getRequestURI().endsWith(".jpg") || request.getRequestURI().endsWith(".jpeg") || request.getRequestURI().endsWith(".tif") || request.getRequestURI().endsWith(".tiff");
    }

    protected String[] decodeCookie(String cookieValue) throws InvalidCookieException {
        for (int j = 0; j < cookieValue.length() % 4; ++j) {
            cookieValue = cookieValue + "=";
        }
        String cookieAsPlainText = null;
        try {
            cookieAsPlainText = new String(Base64.getDecoder().decode(cookieValue.getBytes()));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidCookieException("Cookie token was not Base64 encoded; value was '" + cookieValue + "'");
        }
        String[] tokens = StringUtils.delimitedListToStringArray((String)cookieAsPlainText, (String)DELIMITER);
        for (int i = 0; i < tokens.length; ++i) {
            try {
                tokens[i] = URLDecoder.decode(tokens[i], StandardCharsets.UTF_8.toString());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return tokens;
    }

    public Collection<String> getRequiredPrivileges() {
        return this.requiredPrivileges;
    }

    public void setRequiredPrivileges(Collection<String> requiredPrivileges) {
        this.requiredPrivileges = requiredPrivileges;
    }

    @Autowired(required=false)
    public void setFilterCallback(FlowableCookieFilterCallback filterCallback) {
        this.filterCallback = filterCallback;
    }
}

