/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.conf;

import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableSecurityAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.ui.idm.properties.FlowableIdmAppProperties;
import org.flowable.ui.idm.service.keycloak.KeycloakConfiguration;
import org.flowable.ui.idm.service.keycloak.KeycloakIdentityServiceImpl;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.ldap.LdapAutoConfiguration;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureBefore(value={FlowableSecurityAutoConfiguration.class, IdmEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
@AutoConfigureAfter(value={LdapAutoConfiguration.class})
@ConditionalOnProperty(prefix="flowable.idm.app.keycloak", name={"enabled"}, havingValue="true")
@ConditionalOnMissingBean(name={"ldapIdmEngineConfigurer"})
@Configuration(proxyBeanMethods=false)
public class KeycloakIdmAutoConfiguration {
    protected final FlowableIdmAppProperties properties;

    public KeycloakIdmAutoConfiguration(FlowableIdmAppProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public KeycloakConfiguration flowableKeycloakConfiguration() {
        FlowableIdmAppProperties.Keycloak keycloak = this.properties.getKeycloak();
        KeycloakConfiguration keycloakConfiguration = new KeycloakConfiguration();
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        mapper.from((Object)keycloak.getServer()).to(arg_0 -> ((KeycloakConfiguration)keycloakConfiguration).setServer(arg_0));
        mapper.from((Object)keycloak.getAuthenticationRealm()).to(arg_0 -> ((KeycloakConfiguration)keycloakConfiguration).setAuthenticationRealm(arg_0));
        mapper.from((Object)keycloak.getAuthenticationUser()).to(arg_0 -> ((KeycloakConfiguration)keycloakConfiguration).setAuthenticationUser(arg_0));
        mapper.from((Object)keycloak.getAuthenticationPassword()).to(arg_0 -> ((KeycloakConfiguration)keycloakConfiguration).setAuthenticationPassword(arg_0));
        mapper.from((Object)keycloak.getRealm()).to(arg_0 -> ((KeycloakConfiguration)keycloakConfiguration).setRealm(arg_0));
        return keycloakConfiguration;
    }

    @Bean
    public EngineConfigurationConfigurer<SpringIdmEngineConfiguration> keycloakIdmEngineConfigurer(KeycloakConfiguration keycloakConfiguration) {
        return engineConfiguration -> engineConfiguration.setIdmIdentityService((IdmIdentityService)new KeycloakIdentityServiceImpl(keycloakConfiguration, (IdmEngineConfiguration)engineConfiguration));
    }
}

