/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.conf;

import javax.servlet.Servlet;
import org.flowable.spring.boot.FlowableSecurityAutoConfiguration;
import org.flowable.ui.common.service.idm.RemoteIdmServiceImpl;
import org.flowable.ui.idm.properties.FlowableIdmAppProperties;
import org.flowable.ui.idm.servlet.ApiDispatcherServletConfiguration;
import org.flowable.ui.idm.servlet.AppDispatcherServletConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FlowableIdmAppProperties.class})
@AutoConfigureBefore(value={FlowableSecurityAutoConfiguration.class})
@ComponentScan(basePackages={"org.flowable.ui.idm.conf", "org.flowable.ui.idm.security", "org.flowable.ui.idm.service"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value={RemoteIdmServiceImpl.class})})
public class ApplicationConfiguration {
    @Bean
    public ServletRegistrationBean<DispatcherServlet> idmApiServlet(ApplicationContext applicationContext) {
        AnnotationConfigWebApplicationContext dispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        dispatcherServletConfiguration.setParent(applicationContext);
        dispatcherServletConfiguration.register(new Class[]{ApiDispatcherServletConfiguration.class});
        DispatcherServlet servlet = new DispatcherServlet((WebApplicationContext)dispatcherServletConfiguration);
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, new String[]{"/api/idm/*"});
        registrationBean.setName("Flowable IDM App API Servlet");
        registrationBean.setLoadOnStartup(1);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    public ServletRegistrationBean<DispatcherServlet> idmAppServlet(ApplicationContext applicationContext) {
        AnnotationConfigWebApplicationContext dispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        dispatcherServletConfiguration.setParent(applicationContext);
        dispatcherServletConfiguration.register(new Class[]{AppDispatcherServletConfiguration.class});
        DispatcherServlet servlet = new DispatcherServlet((WebApplicationContext)dispatcherServletConfiguration);
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, new String[]{"/idm-app/*"});
        registrationBean.setName("Flowable IDM App Servlet");
        registrationBean.setLoadOnStartup(1);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    public WebMvcConfigurer idmApplicationWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addViewControllers(@NonNull ViewControllerRegistry registry) {
                if (!ClassUtils.isPresent((String)"org.flowable.ui.task.conf.ApplicationConfiguration", (ClassLoader)this.getClass().getClassLoader())) {
                    registry.addViewController("/").setViewName("redirect:/idm/");
                }
                registry.addViewController("/idm").setViewName("redirect:/idm/");
                registry.addViewController("/idm/").setViewName("forward:/idm/index.html");
            }
        };
    }
}

