/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service;

import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.spring.boot.ldap.FlowableLdapProperties;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.service.idm.cache.BaseUserCache;
import org.flowable.ui.common.service.idm.cache.UserCache;
import org.flowable.ui.idm.model.UserInformation;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class IdmIdentityServiceUserCacheImpl
extends BaseUserCache {
    protected FlowableLdapProperties ldapProperties;
    protected final IdmIdentityService identityService;
    protected final UserService userService;
    protected LoadingCache<String, UserCache.CachedUser> userCache;

    public IdmIdentityServiceUserCacheImpl(FlowableCommonAppProperties properties, IdmIdentityService identityService, UserService userService) {
        super(properties);
        this.identityService = identityService;
        this.userService = userService;
    }

    protected UserCache.CachedUser loadUser(String userId) {
        User userFromDatabase = null;
        userFromDatabase = this.ldapProperties == null || !this.ldapProperties.isEnabled() ? (User)((UserQuery)this.identityService.createUserQuery().userIdIgnoreCase(userId.toLowerCase())).singleResult() : (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (userFromDatabase == null) {
            throw new UsernameNotFoundException("User " + userId + " was not found in the database");
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        UserInformation userInformation = this.userService.getUserInformation(userFromDatabase.getId());
        for (String privilege : userInformation.getPrivileges()) {
            grantedAuthorities.add(new SimpleGrantedAuthority(privilege));
        }
        return new UserCache.CachedUser(userFromDatabase, grantedAuthorities);
    }

    @Autowired(required=false)
    public void setLdapProperties(FlowableLdapProperties ldapProperties) {
        this.ldapProperties = ldapProperties;
    }
}

