/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.rest.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.flowable.idm.api.Group;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.rest.idm.CurrentUserProvider;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.exception.UnauthorizedException;
import org.flowable.ui.idm.model.UserInformation;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AccountResource {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private UserService userService;
    protected final Collection<CurrentUserProvider> currentUserProviders;

    public AccountResource(ObjectProvider<CurrentUserProvider> currentUserProviders) {
        this.currentUserProviders = currentUserProviders.orderedStream().collect(Collectors.toList());
    }

    @GetMapping(value={"/rest/authenticate"}, produces={"application/json"})
    public ObjectNode isAuthenticated(HttpServletRequest request) {
        String user = request.getRemoteUser();
        if (user == null) {
            throw new UnauthorizedException("Request did not contain valid authorization");
        }
        ObjectNode result = this.objectMapper.createObjectNode();
        result.put("login", user);
        return result;
    }

    @GetMapping(value={"/rest/account"}, produces={"application/json"})
    public UserRepresentation getAccount(Authentication authentication) {
        UserRepresentation userRepresentation = null;
        for (CurrentUserProvider userProvider : this.currentUserProviders) {
            if (userProvider.supports(authentication)) {
                userRepresentation = userProvider.getCurrentUser(authentication);
            }
            if (userRepresentation == null) continue;
            break;
        }
        if (userRepresentation == null) {
            userRepresentation = this.getCurrentUserRepresentation(authentication.getName());
        }
        if (userRepresentation != null) {
            return userRepresentation;
        }
        throw new NotFoundException();
    }

    protected UserRepresentation getCurrentUserRepresentation(String currentUserId) {
        UserInformation userInformation = this.userService.getUserInformation(currentUserId);
        if (userInformation != null) {
            UserRepresentation userRepresentation = new UserRepresentation(userInformation.getUser());
            if (userInformation.getGroups() != null) {
                for (Group group : userInformation.getGroups()) {
                    userRepresentation.getGroups().add(new GroupRepresentation(group));
                }
            }
            if (userInformation.getPrivileges() != null) {
                for (String privilege : userInformation.getPrivileges()) {
                    userRepresentation.getPrivileges().add(privilege);
                }
            }
            return userRepresentation;
        }
        return null;
    }
}

