/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.conf;

import java.util.List;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.properties.FlowableModelerAppProperties;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.service.DecisionTableModelConversionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ModelerBootstrapper
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    private FlowableModelerAppProperties modelerAppProperties;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null && (this.modelerAppProperties == null || this.modelerAppProperties.isDecisionTableMigrationEnabled())) {
            this.migrateDecisionTables();
        }
    }

    public void migrateDecisionTables() {
        List decisionTableModels = this.modelRepository.findByModelType(Integer.valueOf(4), "nameAsc");
        decisionTableModels.forEach(decisionTableModel -> {
            if (DecisionTableModelConversionUtil.convertModelToV3((Model)decisionTableModel)) {
                this.modelRepository.save(decisionTableModel);
            }
        });
    }
}

