/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.serviceapi.ModelService;

public class ConverterContext
implements BpmnJsonConverterContext,
CmmnJsonConverterContext,
DmnJsonConverterContext {
    protected ModelService modelService;
    protected ObjectMapper objectMapper;
    protected Map<String, String> processKeyToJsonStringMap = new HashMap<String, String>();
    protected Map<String, String> caseKeyToJsonStringMap = new HashMap<String, String>();
    protected Map<String, String> formKeyToJsonStringMap = new HashMap<String, String>();
    protected Map<String, String> decisionTableKeyToJsonStringMap = new HashMap<String, String>();
    protected Map<String, String> decisionServiceKeyToJsonStringMap = new HashMap<String, String>();
    protected Map<String, Model> processKeyToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> caseKeyToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> formKeyToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> decisionTableKeyToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> referencedDecisionTableKeyToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> decisionServiceKeyToModelMap = new HashMap<String, Model>();
    protected Map<String, byte[]> modelKeyToThumbnailMap = new HashMap<String, byte[]>();
    protected Map<String, Model> processIdToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> caseIdToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> formIdToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> decisionTableIdToModelMap = new HashMap<String, Model>();
    protected Map<String, Model> decisionServiceIdToModelMap = new HashMap<String, Model>();
    protected Map<String, List<CmmnModel>> unresolvedProcessModelKeyToCmmnModels = new HashMap<String, List<CmmnModel>>();
    protected Map<String, List<CmmnModel>> unresolvedCaseModelKeyToCmmnModels = new HashMap<String, List<CmmnModel>>();

    public ConverterContext(ModelService modelService, ObjectMapper objectMapper) {
        this.modelService = modelService;
        this.objectMapper = objectMapper;
    }

    public String getFormModelKeyForFormModelId(String formModelId) {
        return this.getKeyForId(this.formIdToModelMap, formModelId);
    }

    public Map<String, String> getFormModelInfoForFormModelKey(String formModelKey) {
        return this.modelToModelInfo(this.formKeyToModelMap, formModelKey);
    }

    public String getCaseModelKeyForCaseModelId(String caseModelId) {
        return this.getKeyForId(this.caseIdToModelMap, caseModelId);
    }

    public Map<String, String> getCaseModelInfoForCaseModelKey(String caseModelKey) {
        return this.modelToModelInfo(this.caseKeyToModelMap, caseModelKey);
    }

    public String getProcessModelKeyForProcessModelId(String processModelId) {
        return this.getKeyForId(this.processIdToModelMap, processModelId);
    }

    public Map<String, String> getProcessModelInfoForProcessModelKey(String processModelKey) {
        return this.modelToModelInfo(this.processKeyToModelMap, processModelKey);
    }

    public String getDecisionTableModelKeyForDecisionTableModelId(String decisionTableModelId) {
        return this.getKeyForId(this.decisionTableIdToModelMap, decisionTableModelId);
    }

    public Map<String, String> getDecisionTableModelInfoForDecisionTableModelKey(String decisionTableModelKey) {
        return this.modelToModelInfo(this.decisionTableKeyToModelMap, decisionTableModelKey);
    }

    public String getDecisionServiceModelKeyForDecisionServiceModelId(String decisionServiceModelId) {
        return this.getKeyForId(this.decisionServiceIdToModelMap, decisionServiceModelId);
    }

    public Map<String, String> getDecisionServiceModelInfoForDecisionServiceModelKey(String decisionServiceModelKey) {
        return this.modelToModelInfo(this.decisionServiceKeyToModelMap, decisionServiceModelKey);
    }

    protected String getKeyForId(Map<String, Model> modelMap, String id) {
        Model model = modelMap.get(id);
        if (model != null) {
            return model.getKey();
        }
        return null;
    }

    protected Map<String, String> modelToModelInfo(Map<String, Model> modelMap, String key) {
        Model model = modelMap.get(key);
        if (model != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", model.getId());
            map.put("name", model.getName());
            map.put("key", model.getKey());
            return map;
        }
        return null;
    }

    public void addProcessModel(Model model) {
        this.addProcessModel(model, null);
    }

    public void addProcessModel(Model model, String ... oldProcessModelIds) {
        String modelKey = model.getKey();
        this.processKeyToModelMap.put(modelKey, model);
        this.processIdToModelMap.put(model.getId(), model);
        if (oldProcessModelIds != null) {
            for (String oldProcessModelId : oldProcessModelIds) {
                this.processIdToModelMap.put(oldProcessModelId, model);
            }
        }
        if (this.unresolvedProcessModelKeyToCmmnModels != null && !this.unresolvedProcessModelKeyToCmmnModels.isEmpty() && this.unresolvedProcessModelKeyToCmmnModels.containsKey(modelKey)) {
            HashMap<String, List<String>> unresolvedProcessModelKeyToCaseModelKey = new HashMap<String, List<String>>();
            for (String key : this.unresolvedProcessModelKeyToCmmnModels.keySet()) {
                List<CmmnModel> cmmnModels = this.unresolvedProcessModelKeyToCmmnModels.get(key);
                List cmmnModelKeys = cmmnModels.stream().map(cmmnModel -> cmmnModel.getPrimaryCase().getId()).collect(Collectors.toList());
                unresolvedProcessModelKeyToCaseModelKey.put(key, cmmnModelKeys);
            }
            this.handleUnresolvedReferences(modelKey, model, unresolvedProcessModelKeyToCaseModelKey, this.processKeyToModelMap, "processtaskprocessreference");
        }
    }

    public void addCaseModel(Model model) {
        this.addCaseModel(model, null);
    }

    public void addCaseModel(Model model, String ... oldCaseModelIds) {
        String modelKey = model.getKey();
        this.caseKeyToModelMap.put(modelKey, model);
        this.caseIdToModelMap.put(model.getId(), model);
        if (oldCaseModelIds != null) {
            for (String oldCaseModelId : oldCaseModelIds) {
                this.caseIdToModelMap.put(oldCaseModelId, model);
            }
        }
        if (this.unresolvedCaseModelKeyToCmmnModels != null && !this.unresolvedCaseModelKeyToCmmnModels.isEmpty() && this.unresolvedCaseModelKeyToCmmnModels.containsKey(modelKey)) {
            HashMap<String, List<String>> unresolvedCaseModelKeyToCaseModelKey = new HashMap<String, List<String>>();
            for (String key : this.unresolvedCaseModelKeyToCmmnModels.keySet()) {
                List<CmmnModel> cmmnModels = this.unresolvedCaseModelKeyToCmmnModels.get(key);
                List cmmnModelKeys = cmmnModels.stream().map(cmmnModel -> cmmnModel.getPrimaryCase().getId()).collect(Collectors.toList());
                unresolvedCaseModelKeyToCaseModelKey.put(key, cmmnModelKeys);
            }
            this.handleUnresolvedReferences(modelKey, model, unresolvedCaseModelKeyToCaseModelKey, this.caseKeyToModelMap, "casetaskcasereference");
        }
    }

    public void addFormModel(Model model) {
        this.addFormModel(model, null);
    }

    public void addFormModel(Model model, String ... oldFormModelIds) {
        this.formKeyToModelMap.put(model.getKey(), model);
        this.formIdToModelMap.put(model.getId(), model);
        if (oldFormModelIds != null) {
            for (String oldFormModelId : oldFormModelIds) {
                this.formIdToModelMap.put(oldFormModelId, model);
            }
        }
    }

    public void addDecisionTableModel(Model model) {
        this.addDecisionTableModel(model, null);
    }

    public void addReferencedDecisionTableModel(Model model) {
        this.referencedDecisionTableKeyToModelMap.put(model.getKey(), model);
        this.decisionTableIdToModelMap.put(model.getId(), model);
    }

    public void addDecisionTableModel(Model model, String ... oldDecisionTableModelIds) {
        this.decisionTableKeyToModelMap.put(model.getKey(), model);
        this.decisionTableIdToModelMap.put(model.getId(), model);
        if (oldDecisionTableModelIds != null) {
            for (String oldDecisionTableModelId : oldDecisionTableModelIds) {
                this.decisionTableIdToModelMap.put(oldDecisionTableModelId, model);
            }
        }
    }

    public void addReferencedDecisionTableModel(Model model, String ... oldDecisionTableModelIds) {
        this.decisionTableKeyToModelMap.put(model.getKey(), model);
        this.decisionTableIdToModelMap.put(model.getId(), model);
        if (oldDecisionTableModelIds != null) {
            for (String oldDecisionTableModelId : oldDecisionTableModelIds) {
                this.decisionTableIdToModelMap.put(oldDecisionTableModelId, model);
            }
        }
    }

    public void addDecisionServiceModel(Model model) {
        this.addDecisionServiceModel(model, null);
    }

    public void addDecisionServiceModel(Model model, String ... oldDecisionServiceModelIds) {
        this.decisionServiceKeyToModelMap.put(model.getKey(), model);
        this.decisionServiceIdToModelMap.put(model.getId(), model);
        if (oldDecisionServiceModelIds != null) {
            for (String oldDecisionServiceModelId : oldDecisionServiceModelIds) {
                this.decisionServiceIdToModelMap.put(oldDecisionServiceModelId, model);
            }
        }
    }

    protected void handleUnresolvedReferences(String modelKey, Model model, Map<String, List<String>> unresolvedReferencesMap, Map<String, Model> keyToModelMap, String referenceProperyName) {
        if (unresolvedReferencesMap.containsKey(modelKey)) {
            List<String> referencingModelKeys = unresolvedReferencesMap.get(modelKey);
            for (String referencingCaseModelKey : referencingModelKeys) {
                Model referencingCaseModel = keyToModelMap.get(referencingCaseModelKey);
                try {
                    JsonNode referencingCaseModelJson = this.objectMapper.readTree(referencingCaseModel.getModelEditorJson());
                    this.updateModelReferenceProperties(model, referenceProperyName, referencingCaseModelJson);
                    referencingCaseModel.setModelEditorJson(referencingCaseModelJson.toString());
                    this.modelService.saveModel(referencingCaseModel);
                }
                catch (Exception e) {
                    throw new FlowableException("Could not read model json", (Throwable)e);
                }
            }
            unresolvedReferencesMap.remove(modelKey);
        }
    }

    protected void updateModelReferenceProperties(Model model, String referenceProperyName, JsonNode referencingCaseModelJson) {
        for (JsonNode childNode : referencingCaseModelJson) {
            if (childNode.has(referenceProperyName)) {
                ObjectNode referenceNode = (ObjectNode)childNode.get(referenceProperyName);
                referenceNode.put("id", model.getId());
                referenceNode.put("name", model.getName());
                continue;
            }
            this.updateModelReferenceProperties(model, referenceProperyName, childNode);
        }
    }

    public Model getProcessModelByKey(String key) {
        return this.processKeyToModelMap.get(key);
    }

    public Model getProcessModelById(String id) {
        return this.processIdToModelMap.get(id);
    }

    public Model getCaseModelByKey(String key) {
        return this.caseKeyToModelMap.get(key);
    }

    public Model getCaseModelById(String id) {
        return this.caseIdToModelMap.get(id);
    }

    public Model getFormModelByKey(String key) {
        return this.formKeyToModelMap.get(key);
    }

    public Model getFormModelById(String id) {
        return this.formIdToModelMap.get(id);
    }

    public Model getDecisionTableModelByKey(String key) {
        return this.decisionTableKeyToModelMap.get(key);
    }

    public Model getDecisionTableModelById(String id) {
        return this.decisionTableIdToModelMap.get(id);
    }

    public Model getDecisionServiceModelByKey(String key) {
        return this.decisionServiceKeyToModelMap.get(key);
    }

    public Model getDecisionServiceModelById(String id) {
        return this.decisionServiceIdToModelMap.get(id);
    }

    public Collection<Model> getAllProcessModels() {
        return this.processKeyToModelMap.values();
    }

    public Collection<Model> getAllCaseModels() {
        return this.caseKeyToModelMap.values();
    }

    public Collection<Model> getAllDecisionTableModels() {
        return this.decisionTableKeyToModelMap.values();
    }

    public Collection<Model> getAllReferencedDecisionTableModels() {
        return this.referencedDecisionTableKeyToModelMap.values();
    }

    public Collection<Model> getAllDecisionServiceModels() {
        return this.decisionServiceKeyToModelMap.values();
    }

    public Collection<Model> getAllFormModels() {
        return this.formKeyToModelMap.values();
    }

    public Map<String, String> getProcessKeyToJsonStringMap() {
        return this.processKeyToJsonStringMap;
    }

    public Map<String, String> getCaseKeyToJsonStringMap() {
        return this.caseKeyToJsonStringMap;
    }

    public Map<String, String> getFormKeyToJsonStringMap() {
        return this.formKeyToJsonStringMap;
    }

    public Map<String, String> getDecisionTableKeyToJsonStringMap() {
        return this.decisionTableKeyToJsonStringMap;
    }

    public Map<String, String> getDecisionServiceKeyToJsonStringMap() {
        return this.decisionServiceKeyToJsonStringMap;
    }

    public Map<String, byte[]> getModelKeyToThumbnailMap() {
        return this.modelKeyToThumbnailMap;
    }

    public void setModelKeyToThumbnailMap(Map<String, byte[]> modelKeyToThumbnailMap) {
        this.modelKeyToThumbnailMap = modelKeyToThumbnailMap;
    }

    public void registerUnresolvedCaseModelReferenceForCaseModel(String unresolvedCaseModelKey, CmmnModel cmmnModel) {
        this.unresolvedCaseModelKeyToCmmnModels.computeIfAbsent(unresolvedCaseModelKey, key -> new ArrayList()).add(cmmnModel);
    }

    public void registerUnresolvedProcessModelReferenceForCaseModel(String unresolvedProcessModelKey, CmmnModel cmmnModel) {
        this.unresolvedProcessModelKeyToCmmnModels.computeIfAbsent(unresolvedProcessModelKey, key -> new ArrayList()).add(cmmnModel);
    }
}

