/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.casemodel.CaseRepresentation;
import org.flowable.ui.modeler.service.BaseFlowableModelService;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableCaseModelService
extends BaseFlowableModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCaseModelService.class);
    protected static final int MIN_FILTER_LENGTH = 1;
    @Autowired
    protected ModelService modelService;

    public ResultListDataRepresentation getCases(String filter, String excludeId) {
        String validFilter = this.makeValidFilterText(filter);
        List<Model> models = null;
        models = validFilter != null ? this.modelRepository.findByModelTypeAndFilter(5, validFilter, "nameAsc") : this.modelRepository.findByModelType(5, "nameAsc");
        ArrayList<CaseRepresentation> reps = new ArrayList<CaseRepresentation>();
        for (Model model : models) {
            if (model.getId().equals(excludeId)) continue;
            reps.add(new CaseRepresentation(model));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(reps);
        result.setTotal(Long.valueOf(models.size()));
        return result;
    }

    protected String makeValidFilterText(String filterText) {
        String trimmed;
        String validFilter = null;
        if (filterText != null && (trimmed = StringUtils.trim((String)filterText)).length() >= 1) {
            validFilter = "%" + trimmed.toLowerCase() + "%";
        }
        return validFilter;
    }
}

