/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import org.flowable.ui.common.model.BaseRestActionRepresentation;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.model.ReviveModelResultRepresentation;
import org.flowable.ui.modeler.rest.app.AbstractModelHistoryResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class ModelHistoryResource
extends AbstractModelHistoryResource {
    @Override
    @RequestMapping(value={"/rest/models/{modelId}/history"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getModelHistoryCollection(@PathVariable String modelId, @RequestParam(value="includeLatestVersion", required=false) Boolean includeLatestVersion) {
        return super.getModelHistoryCollection(modelId, includeLatestVersion);
    }

    @Override
    @RequestMapping(value={"/rest/models/{modelId}/history/{modelHistoryId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelRepresentation getProcessModelHistory(@PathVariable String modelId, @PathVariable String modelHistoryId) {
        return super.getProcessModelHistory(modelId, modelHistoryId);
    }

    @RequestMapping(value={"/rest/models/{modelId}/history/{modelHistoryId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ReviveModelResultRepresentation executeProcessModelHistoryAction(@PathVariable String modelId, @PathVariable String modelHistoryId, @RequestBody(required=true) BaseRestActionRepresentation action) {
        ModelHistory modelHistory = this.modelService.getModelHistory(modelId, modelHistoryId);
        if ("useAsNewVersion".equals(action.getAction())) {
            return this.modelService.reviveProcessModelHistory(modelHistory, SecurityUtils.getCurrentUserObject(), action.getComment());
        }
        throw new BadRequestException("Invalid action to execute on model history " + modelHistoryId + ": " + action.getAction());
    }
}

