/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.ModelKeyRepresentation;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.service.FlowableModelQueryService;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class ApiModelsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiModelsResource.class);
    @Autowired
    protected FlowableModelQueryService modelQueryService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;

    @GetMapping(value={"/models"}, produces={"application/json"})
    public ResultListDataRepresentation getModels(@RequestParam(required=false) String filter, @RequestParam(required=false) String sort, @RequestParam(required=false) Integer modelType, HttpServletRequest request) {
        return this.modelQueryService.getModels(filter, sort, modelType, request);
    }

    @PostMapping(value={"/import-process-model"}, produces={"application/json"})
    public ModelRepresentation importProcessModel(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        return this.modelQueryService.importProcessModel(request, file);
    }

    @PostMapping(value={"/models"}, produces={"application/json"})
    public ModelRepresentation createModel(@RequestBody ModelRepresentation modelRepresentation) {
        modelRepresentation.setKey(modelRepresentation.getKey().replaceAll(" ", ""));
        ModelKeyRepresentation modelKeyInfo = this.modelService.validateModelKey(null, modelRepresentation.getModelType(), modelRepresentation.getKey());
        if (modelKeyInfo.isKeyAlreadyExists()) {
            throw new BadRequestException("Provided model key already exists: " + modelRepresentation.getKey());
        }
        String json = this.modelService.createModelJson(modelRepresentation);
        Model newModel = this.modelService.createModel(modelRepresentation, json, SecurityUtils.getCurrentUserId());
        return new ModelRepresentation((AbstractModel)newModel);
    }
}

