/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.service.ConverterContext;
import org.flowable.ui.modeler.service.ModelRelationService;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.flowable.validation.ProcessValidator;
import org.flowable.validation.ProcessValidatorFactory;
import org.flowable.validation.ValidationError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ModelValidationRestResource {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRelationService modelRelationService;
    @Autowired
    protected ObjectMapper objectMapper;

    @PostMapping(value={"/rest/model/validate"}, consumes={"application/json"})
    public List<ValidationError> validate(@RequestBody JsonNode body) {
        String namespace;
        JsonNode stencilset;
        if (body != null && body.has("stencilset") && (stencilset = body.get("stencilset")).has("namespace") && (namespace = stencilset.get("namespace").asText()).endsWith("bpmn2.0#")) {
            ConverterContext converterContext = this.initBpmnConverterContext(body);
            BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(body, (BpmnJsonConverterContext)converterContext);
            ProcessValidator validator = new ProcessValidatorFactory().createDefaultProcessValidator();
            List errors = validator.validate(bpmnModel);
            return errors;
        }
        return Collections.emptyList();
    }

    protected ConverterContext initBpmnConverterContext(JsonNode editorJsonNode) {
        ConverterContext converterContext = new ConverterContext(this.modelService, this.objectMapper);
        this.gatherFormModelsFromBpmnJson(editorJsonNode).forEach(arg_0 -> ((ConverterContext)converterContext).addFormModel(arg_0));
        this.gatherDecisionTableModelsFromBpmnJson(editorJsonNode).forEach(arg_0 -> ((ConverterContext)converterContext).addDecisionTableModel(arg_0));
        this.gatherDecisionServiceModelsFromBpmnJson(editorJsonNode).forEach(arg_0 -> ((ConverterContext)converterContext).addDecisionServiceModel(arg_0));
        return converterContext;
    }

    protected List<Model> gatherFormModelsFromBpmnJson(JsonNode editorJsonNode) {
        List formReferenceNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelFormReferences((JsonNode)editorJsonNode));
        Set formIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)formReferenceNodes, (String)"id");
        List<Model> formModels = formIds.stream().map(formId -> this.modelService.getModel(formId)).collect(Collectors.toList());
        return formModels;
    }

    protected List<Model> gatherDecisionTableModelsFromBpmnJson(JsonNode editorJsonNode) {
        List decisionTableReferenceNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelDecisionTableReferences((JsonNode)editorJsonNode));
        Set decisionTableIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)decisionTableReferenceNodes, (String)"id");
        List<Model> decisionTableModels = decisionTableIds.stream().map(decisionTableId -> this.modelService.getModel(decisionTableId)).collect(Collectors.toList());
        return decisionTableModels;
    }

    protected List<Model> gatherDecisionServiceModelsFromBpmnJson(JsonNode editorJsonNode) {
        List decisionServiceReferenceNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelDecisionServiceReferences((JsonNode)editorJsonNode));
        Set decisionServiceIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)decisionServiceReferenceNodes, (String)"id");
        List<Model> decisionServiceModels = decisionServiceIds.stream().map(decisionServiceId -> this.modelService.getModel(decisionServiceId)).collect(Collectors.toList());
        return decisionServiceModels;
    }
}

