/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.flowable.ui.task.service.editor.mapper;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ScriptTask;

public class ScriptTaskInfoMapper extends AbstractInfoMapper {

    @Override
    protected void mapProperties(Object element) {
        ScriptTask scriptTask = (ScriptTask) element;
        if (StringUtils.isNotEmpty(scriptTask.getScriptFormat())) {
            createPropertyNode("Script format", scriptTask.getScriptFormat());
        }
        if (StringUtils.isNotEmpty(scriptTask.getScript())) {
            createPropertyNode("Script", scriptTask.getScript());
        }
        createListenerPropertyNodes("Execution listeners", scriptTask.getExecutionListeners());
    }
}
