/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.identitylink.api.history.HistoricIdentityLink;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.security.SecurityScope;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.idm.cache.UserCache;
import org.flowable.ui.task.model.runtime.TaskRepresentation;
import org.flowable.ui.task.model.runtime.TaskUpdateRepresentation;
import org.flowable.ui.task.service.runtime.FlowableAbstractTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableTaskService
extends FlowableAbstractTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableTaskService.class);

    public TaskRepresentation getTask(String taskId) {
        SecurityScope currentUser = SecurityUtils.getAuthenticatedSecurityScope();
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(currentUser, taskId);
        TaskRepresentation rep = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getProcessDefinitionId())) {
            try {
                ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(task.getProcessDefinitionId());
                rep = new TaskRepresentation((TaskInfo)task, processDefinition);
            }
            catch (FlowableException e) {
                LOGGER.error("Error getting process definition {}", (Object)task.getProcessDefinitionId(), (Object)e);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)task.getScopeDefinitionId())) {
            try {
                CaseDefinition caseDefinition = this.cmmnRepositoryService.getCaseDefinition(task.getScopeDefinitionId());
                rep = new TaskRepresentation((TaskInfo)task, caseDefinition);
            }
            catch (FlowableException e) {
                LOGGER.error("Error getting case definition {}", (Object)task.getScopeDefinitionId(), (Object)e);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)task.getParentTaskId())) {
            HistoricTaskInstance parentTask = this.permissionService.validateReadPermissionOnTask(currentUser, task.getParentTaskId());
            rep = new TaskRepresentation((TaskInfo)task, (TaskInfo)parentTask);
        } else {
            rep = new TaskRepresentation(task);
        }
        this.fillPermissionInformation(rep, (TaskInfo)task, currentUser);
        this.populateAssignee((TaskInfo)task, rep);
        rep.setInvolvedPeople(this.getInvolvedUsers(taskId));
        return rep;
    }

    public List<TaskRepresentation> getSubTasks(String taskId) {
        SecurityScope currentUser = SecurityUtils.getAuthenticatedSecurityScope();
        HistoricTaskInstance parentTask = this.permissionService.validateReadPermissionOnTask(currentUser, taskId);
        List subTasks = this.taskService.getSubTasks(taskId);
        ArrayList<TaskRepresentation> subTasksRepresentations = new ArrayList<TaskRepresentation>(subTasks.size());
        for (Task subTask : subTasks) {
            TaskRepresentation representation = new TaskRepresentation((TaskInfo)subTask, (TaskInfo)parentTask);
            this.fillPermissionInformation(representation, (TaskInfo)subTask, currentUser);
            this.populateAssignee((TaskInfo)subTask, representation);
            representation.setInvolvedPeople(this.getInvolvedUsers(subTask.getId()));
            subTasksRepresentations.add(representation);
        }
        return subTasksRepresentations;
    }

    protected void populateAssignee(TaskInfo task, TaskRepresentation rep) {
        if (task.getAssignee() != null) {
            UserCache.CachedUser cachedUser = this.userCache.getUser(task.getAssignee());
            if (cachedUser != null && cachedUser.getUser() != null) {
                rep.setAssignee(new UserRepresentation(cachedUser.getUser()));
            } else {
                rep.setAssignee(new UserRepresentation(task.getAssignee()));
            }
        }
    }

    protected List<UserRepresentation> getInvolvedUsers(String taskId) {
        List idLinks = this.historyService.getHistoricIdentityLinksForTask(taskId);
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>(idLinks.size());
        for (HistoricIdentityLink link : idLinks) {
            if (link.getUserId() == null || "assignee".equals(link.getType())) continue;
            UserCache.CachedUser cachedUser = this.userCache.getUser(link.getUserId());
            if (cachedUser != null && cachedUser.getUser() != null) {
                result.add(new UserRepresentation(cachedUser.getUser()));
                continue;
            }
            result.add(new UserRepresentation(link.getUserId()));
        }
        return result;
    }

    public TaskRepresentation updateTask(String taskId, TaskUpdateRepresentation updated) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getAuthenticatedSecurityScope(), task.getId());
        if (updated.isNameSet()) {
            task.setName(updated.getName());
        }
        if (updated.isDescriptionSet()) {
            task.setDescription(updated.getDescription());
        }
        if (updated.isDueDateSet()) {
            task.setDueDate(updated.getDueDate());
        }
        this.taskService.saveTask(task);
        return new TaskRepresentation(task);
    }
}

