/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.content.api.ContentItem;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.security.SecurityScope;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PermissionService {
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected CmmnHistoryService cmmnHistoryService;

    public HistoricTaskInstance validateReadPermissionOnTask(SecurityScope user, String taskId) {
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).taskInvolvedUser(String.valueOf(user.getUserId()))).list();
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            return (HistoricTaskInstance)tasks.get(0);
        }
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.taskId(taskId);
        Set groupIds = user.getGroupIds();
        if (!groupIds.isEmpty()) {
            historicTaskInstanceQuery.taskCandidateGroupIn((Collection)groupIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(tasks = historicTaskInstanceQuery.list()))) {
            return (HistoricTaskInstance)tasks.get(0);
        }
        tasks = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).list();
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            HistoricTaskInstance task = (HistoricTaskInstance)tasks.get(0);
            if (task != null && task.getProcessInstanceId() != null) {
                boolean hasReadPermissionOnProcessInstance = this.hasReadPermissionOnProcessInstance(user, task.getProcessInstanceId());
                if (hasReadPermissionOnProcessInstance) {
                    return task;
                }
            } else if (task != null && task.getParentTaskId() != null) {
                this.validateReadPermissionOnTask(user, task.getParentTaskId());
                return task;
            }
        }
        throw new NotPermittedException("User is not allowed to work with task " + taskId);
    }

    private List<String> getGroupIdsForUser(User user) {
        ArrayList<String> groupIds = new ArrayList<String>();
        RemoteUser remoteUser = (RemoteUser)user;
        for (Group group : remoteUser.getGroups()) {
            groupIds.add(String.valueOf(group.getId()));
        }
        return groupIds;
    }

    public boolean isTaskOwnerOrAssignee(SecurityScope user, String taskId) {
        return this.isTaskOwnerOrAssignee(user, (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult());
    }

    public boolean isTaskOwnerOrAssignee(SecurityScope user, Task task) {
        String currentUser = user.getUserId();
        return currentUser.equals(task.getAssignee()) || currentUser.equals(task.getOwner());
    }

    public boolean validateIfUserIsInitiatorAndCanCompleteTask(SecurityScope user, Task task) {
        HistoricCaseInstance historicCaseInstance;
        boolean canCompleteTask = false;
        if (task.getProcessInstanceId() != null) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            if (historicProcessInstance != null && StringUtils.isNotEmpty((CharSequence)historicProcessInstance.getStartUserId())) {
                String value;
                UserTask userTask;
                List extensionElements;
                BpmnModel bpmnModel;
                FlowElement flowElement;
                String processInstanceStartUserId = historicProcessInstance.getStartUserId();
                if (String.valueOf(user.getUserId()).equals(processInstanceStartUserId) && (flowElement = (bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId())).getFlowElement(task.getTaskDefinitionKey())) instanceof UserTask && CollectionUtils.isNotEmpty((Collection)(extensionElements = (List)(userTask = (UserTask)flowElement).getExtensionElements().get("initiator-can-complete"))) && StringUtils.isNotEmpty((CharSequence)(value = ((ExtensionElement)extensionElements.get(0)).getElementText())) && Boolean.valueOf(value).booleanValue()) {
                    canCompleteTask = true;
                }
            }
        } else if (task.getScopeId() != null && (historicCaseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(task.getScopeId()).singleResult()) != null && StringUtils.isNotEmpty((CharSequence)historicCaseInstance.getStartUserId())) {
            String caseInstanceStartUserId = historicCaseInstance.getStartUserId();
            if (String.valueOf(user.getUserId()).equals(caseInstanceStartUserId)) {
                canCompleteTask = true;
            }
        }
        return canCompleteTask;
    }

    public boolean isInvolved(SecurityScope user, String taskId) {
        return ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).taskInvolvedUser(user.getUserId())).count() == 1L;
    }

    public boolean hasReadPermissionOnProcessInstance(SecurityScope user, String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        return this.hasReadPermissionOnProcessInstance(user, historicProcessInstance, processInstanceId);
    }

    public boolean hasReadPermissionOnCase(SecurityScope user, String caseId) {
        HistoricCaseInstance historicCaseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseId).singleResult();
        return this.hasReadPermissionOnCaseInstance(user, historicCaseInstance, caseId);
    }

    public boolean hasReadPermissionOnProcessInstance(SecurityScope user, HistoricProcessInstance historicProcessInstance, String processInstanceId) {
        if (historicProcessInstance == null) {
            throw new NotFoundException("Process instance not found for id " + processInstanceId);
        }
        if (historicProcessInstance.getStartUserId() != null && historicProcessInstance.getStartUserId().equals(user.getUserId())) {
            return true;
        }
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        historicProcessInstanceQuery.processInstanceId(processInstanceId);
        historicProcessInstanceQuery.involvedUser(user.getUserId());
        if (historicProcessInstanceQuery.count() > 0L) {
            return true;
        }
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.processInstanceId(processInstanceId);
        historicTaskInstanceQuery.taskInvolvedUser(user.getUserId());
        if (historicTaskInstanceQuery.count() > 0L) {
            return true;
        }
        Set groupIds = user.getGroupIds();
        if (!groupIds.isEmpty()) {
            historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
            ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.processInstanceId(processInstanceId)).taskCandidateGroupIn((Collection)groupIds);
            return historicTaskInstanceQuery.count() > 0L;
        }
        return false;
    }

    public boolean hasReadPermissionOnCaseInstance(SecurityScope user, HistoricCaseInstance historicCaseInstance, String caseInstanceId) {
        if (historicCaseInstance == null) {
            throw new NotFoundException("Case instance not found for id " + caseInstanceId);
        }
        if (historicCaseInstance.getStartUserId() != null && historicCaseInstance.getStartUserId().equals(user.getUserId())) {
            return true;
        }
        if (user.getUserId().equals(historicCaseInstance.getStartUserId())) {
            return true;
        }
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.cmmnHistoryService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.caseInstanceId(caseInstanceId);
        historicTaskInstanceQuery.taskInvolvedUser(user.getUserId());
        if (historicTaskInstanceQuery.count() > 0L) {
            return true;
        }
        Set groupIds = user.getGroupIds();
        if (!groupIds.isEmpty()) {
            historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
            ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.caseInstanceId(caseInstanceId)).taskCandidateGroupIn((Collection)groupIds);
            return historicTaskInstanceQuery.count() > 0L;
        }
        return false;
    }

    public boolean canAddRelatedContentToTask(SecurityScope user, String taskId) {
        this.validateReadPermissionOnTask(user, taskId);
        return true;
    }

    public boolean canAddRelatedContentToProcessInstance(SecurityScope user, String processInstanceId) {
        return this.hasReadPermissionOnProcessInstance(user, processInstanceId);
    }

    public boolean canAddRelatedContentToCase(SecurityScope user, String caseId) {
        return this.hasReadPermissionOnCase(user, caseId);
    }

    public boolean canDownloadContent(SecurityScope currentUserObject, ContentItem content) {
        if (content.getTaskId() != null) {
            this.validateReadPermissionOnTask(currentUserObject, content.getTaskId());
            return true;
        }
        if (content.getProcessInstanceId() != null) {
            return this.hasReadPermissionOnProcessInstance(currentUserObject, content.getProcessInstanceId());
        }
        if ("cmmn".equals(content.getScopeType())) {
            return this.hasReadPermissionOnCase(currentUserObject, content.getScopeId());
        }
        return false;
    }

    public boolean hasWritePermissionOnRelatedContent(SecurityScope user, ContentItem content) {
        if (content.getProcessInstanceId() != null) {
            return this.hasReadPermissionOnProcessInstance(user, content.getProcessInstanceId());
        }
        if (content.getCreatedBy() != null) {
            return content.getCreatedBy().equals(user.getUserId());
        }
        return false;
    }

    public boolean canDeleteProcessInstance(SecurityScope currentUser, HistoricProcessInstance processInstance) {
        boolean canDelete = false;
        if (processInstance.getStartUserId() != null) {
            canDelete = processInstance.getStartUserId().equals(currentUser.getUserId());
        }
        return canDelete;
    }

    public boolean canStartProcess(SecurityScope user, ProcessDefinition definition) {
        List identityLinks = this.repositoryService.getIdentityLinksForProcessDefinition(definition.getId());
        List<String> startUserIds = this.getPotentialStarterUserIds(identityLinks);
        List<String> startGroupIds = this.getPotentialStarterGroupIds(identityLinks);
        if (startUserIds.isEmpty() && startGroupIds.isEmpty()) {
            return true;
        }
        if (startUserIds.contains(user.getUserId())) {
            return true;
        }
        Set groupsIds = user.getGroupIds();
        for (String startGroupId : startGroupIds) {
            if (!groupsIds.contains(startGroupId)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getPotentialStarterGroupIds(List<IdentityLink> identityLinks) {
        ArrayList<String> groupIds = new ArrayList<String>();
        for (IdentityLink identityLink : identityLinks) {
            if (identityLink.getGroupId() == null || identityLink.getGroupId().length() <= 0 || groupIds.contains(identityLink.getGroupId())) continue;
            groupIds.add(identityLink.getGroupId());
        }
        return groupIds;
    }

    protected List<String> getPotentialStarterUserIds(List<IdentityLink> identityLinks) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (IdentityLink identityLink : identityLinks) {
            if (identityLink.getUserId() == null || identityLink.getUserId().length() <= 0 || userIds.contains(identityLink.getUserId())) continue;
            userIds.add(identityLink.getUserId());
        }
        return userIds;
    }
}

