/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class LocalDateTimeType
implements VariableType {
    public static final String TYPE_NAME = "localdatetime";

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return LocalDateTime.class.isAssignableFrom(value.getClass());
    }

    public Object getValue(ValueFields valueFields) {
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(longValue), ZoneOffset.UTC);
        }
        return null;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(Long.valueOf(((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli()));
        } else {
            valueFields.setLongValue(null);
        }
    }
}

