/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger.scala.sender;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.liftweb.json.DefaultFormats$;
import net.liftweb.json.Formats;
import net.liftweb.json.Serialization$;
import net.liftweb.json.Serializer;
import org.fluentd.logger.scala.sender.Event;
import org.fluentd.logger.scala.sender.EventSerializer$;
import org.fluentd.logger.scala.sender.MapSerializer$;
import org.fluentd.logger.scala.sender.Sender;
import org.fluentd.logger.sender.ExponentialDelayReconnector;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u00015\u0011AcU2bY\u0006\u0014\u0016m^*pG.,GoU3oI\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0019XM\u001c3fe*\u0011QAB\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000f!\ta\u0001\\8hO\u0016\u0014(BA\u0005\u000b\u0003\u001d1G.^3oi\u0012T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u000191\"\u0004\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\u0002$D\u0001\u0003\u0013\tI\"A\u0001\u0004TK:$WM\u001d\t\u00037ui\u0011\u0001\b\u0006\u0002\u000b%\u0011a\u0004\b\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0005A\u0007C\u0001\u0012&\u001d\tY2%\u0003\u0002%9\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!C\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\u0005\u0001\bCA\u000e,\u0013\taCDA\u0002J]RD\u0001B\f\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0003i>D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0007EV47)\u00199\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0015!TGN\u001c9!\t9\u0002\u0001C\u0003!c\u0001\u0007\u0011\u0005C\u0003*c\u0001\u0007!\u0006C\u0003/c\u0001\u0007!\u0006C\u00031c\u0001\u0007!\u0006C\u0004;\u0001\t\u0007I1A\u001e\u0002\u000f\u0019|'/\\1ugV\tA\b\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006!!n]8o\u0015\t\t%)A\u0004mS\u001a$x/\u001a2\u000b\u0003\r\u000b1A\\3u\u0013\t)eHA\u0004G_Jl\u0017\r^:\t\r\u001d\u0003\u0001\u0015!\u0003=\u0003!1wN]7biN\u0004\u0003bB%\u0001\u0005\u0004%\tAS\u0001\u0004\u0019>;U#A&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015a\u00027pO\u001eLgn\u001a\u0006\u0003!J\tA!\u001e;jY&\u0011!+\u0014\u0002\u0007\u0019><w-\u001a:\t\rQ\u0003\u0001\u0015!\u0003L\u0003\u0011auj\u0012\u0011\t\u000fY\u0003!\u0019!C\u0001/\u0006!\u0001n\\:u+\u0005\t\u0003BB-\u0001A\u0003%\u0011%A\u0003i_N$\b\u0005C\u0004\\\u0001\t\u0007I\u0011\u0001/\u0002\tA|'\u000f^\u000b\u0002U!1a\f\u0001Q\u0001\n)\nQ\u0001]8si\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005A,\u0001\bck\u001a4WM]\"ba\u0006\u001c\u0017\u000e^=\t\r\t\u0004\u0001\u0015!\u0003+\u0003=\u0011WO\u001a4fe\u000e\u000b\u0007/Y2jif\u0004\u0003b\u00023\u0001\u0005\u0004%\t\u0001X\u0001\bi&lWm\\;u\u0011\u00191\u0007\u0001)A\u0005U\u0005AA/[7f_V$\b\u0005C\u0004i\u0001\t\u0007I\u0011A,\u0002\t9\fW.\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B\u0011\u0002\u000b9\fW.\u001a\u0011\t\u000f1\u0004!\u0019!C\u0001[\u0006A\u0001/\u001a8eS:<7/F\u0001o!\ty'/D\u0001q\u0015\t\t(#A\u0002oS>L!a\u001d9\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0004v\u0001\u0001\u0006IA\\\u0001\na\u0016tG-\u001b8hg\u0002Bqa\u001e\u0001C\u0002\u0013\u0005\u00010\u0001\u0004tKJ4XM]\u000b\u0002sB\u0011!\u0010`\u0007\u0002w*\u00111IE\u0005\u0003{n\u0014\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011\u0019y\b\u0001)A\u0005s\u000691/\u001a:wKJ\u0004\u0003\"CA\u0002\u0001\t\u0007I\u0011AA\u0003\u0003-\u0011XmY8o]\u0016\u001cGo\u001c:\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u001bi!!a\u0003\u000b\u0005\r1\u0011\u0002BA\b\u0003\u0017\u00111$\u0012=q_:,g\u000e^5bY\u0012+G.Y=SK\u000e|gN\\3di>\u0014\b\u0002CA\n\u0001\u0001\u0006I!a\u0002\u0002\u0019I,7m\u001c8oK\u000e$xN\u001d\u0011\t\u0013\u0005]\u0001\u00011A\u0005\u0002\u0005e\u0011AB:pG.,G/\u0006\u0002\u0002\u001cA\u0019!0!\b\n\u0007\u0005}1P\u0001\u0004T_\u000e\\W\r\u001e\u0005\n\u0003G\u0001\u0001\u0019!C\u0001\u0003K\t!b]8dW\u0016$x\fJ3r)\u0011\t9#!\f\u0011\u0007m\tI#C\u0002\u0002,q\u0011A!\u00168ji\"Q\u0011qFA\u0011\u0003\u0003\u0005\r!a\u0007\u0002\u0007a$\u0013\u0007\u0003\u0005\u00024\u0001\u0001\u000b\u0015BA\u000e\u0003\u001d\u0019xnY6fi\u0002B\u0011\"a\u000e\u0001\u0001\u0004%\t!!\u000f\u0002\u0007=,H/\u0006\u0002\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002BI\t!![8\n\t\u0005\u0015\u0013q\b\u0002\u0015\u0005V4g-\u001a:fI>+H\u000f];u'R\u0014X-Y7\t\u0013\u0005%\u0003\u00011A\u0005\u0002\u0005-\u0013aB8vi~#S-\u001d\u000b\u0005\u0003O\ti\u0005\u0003\u0006\u00020\u0005\u001d\u0013\u0011!a\u0001\u0003wA\u0001\"!\u0015\u0001A\u0003&\u00111H\u0001\u0005_V$\b\u0005\u0003\u00043\u0001\u0011\u0005\u0011Q\u000b\u000b\u0006i\u0005]\u0013\u0011\f\u0005\u0007-\u0006M\u0003\u0019A\u0011\t\rm\u000b\u0019\u00061\u0001+\u0011\u0019\u0011\u0004\u0001\"\u0001\u0002^Q\tA\u0007C\u0004\u0002b\u0001!\t!a\u0019\u0002\t=\u0004XM\u001c\u000b\u0003\u0003OAq!a\u001a\u0001\t\u0003\t\u0019'A\u0004d_:tWm\u0019;\t\u000f\u0005-\u0004\u0001\"\u0001\u0002d\u0005I!/Z2p]:,7\r\u001e\u0005\b\u0003_\u0002A\u0011AA2\u0003\u0015\u0019Gn\\:f\u0011\u001d\t\u0019\b\u0001C\u0001\u0003k\nA!Z7jiR1\u0011qOA?\u0003\u0003\u00032aGA=\u0013\r\tY\b\b\u0002\b\u0005>|G.Z1o\u0011\u001d\ty(!\u001dA\u0002\u0005\n1\u0001^1h\u0011!\t\u0019)!\u001dA\u0002\u0005\u0015\u0015\u0001\u00023bi\u0006\u0004r!a\"\u0002\u000e\u0006\n\t*\u0004\u0002\u0002\n*\u0019\u00111\u0012\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0006%%aA'baB\u00191$a%\n\u0007\u0005UEDA\u0002B]fDq!a\u001d\u0001\t\u0003\tI\n\u0006\u0005\u0002x\u0005m\u0015QTAT\u0011\u001d\ty(a&A\u0002\u0005B\u0001\"a(\u0002\u0018\u0002\u0007\u0011\u0011U\u0001\ni&lWm\u001d;b[B\u00042aGAR\u0013\r\t)\u000b\b\u0002\u0005\u0019>tw\r\u0003\u0005\u0002\u0004\u0006]\u0005\u0019AAC\u0011\u001d\t\u0019\b\u0001C\u0001\u0003W#B!a\u001e\u0002.\"A\u0011qVAU\u0001\u0004\t\t,A\u0003fm\u0016tG\u000fE\u0002\u0018\u0003gK1!!.\u0003\u0005\u0015)e/\u001a8u\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000bAa]3oIR!\u0011qOA_\u0011!\ty,a.A\u0002\u0005\u0005\u0017!\u00022zi\u0016\u001c\b#B\u000e\u0002D\u0006\u001d\u0017bAAc9\t)\u0011I\u001d:bsB\u00191$!3\n\u0007\u0005-GD\u0001\u0003CsR,\u0007bBAh\u0001\u0011\u0005\u0011\u0011[\u0001\nO\u0016$()\u001e4gKJ$\"!!1\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\u0006Y1\r\\3be\n+hMZ3s)\t\tI\u000eE\u0002p\u00037L1!!8q\u0005\u0019\u0011UO\u001a4fe\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0014!\u00024mkND\u0007bBAs\u0001\u0011\u0005\u0011q]\u0001\bO\u0016$h*Y7f)\u0005\t\u0003bBAv\u0001\u0011\u0005\u0013q]\u0001\ti>\u001cFO]5oO\u0002")
public class ScalaRawSocketSender
implements Sender,
ScalaObject {
    private final Formats formats = DefaultFormats$.MODULE$.$plus((Serializer)EventSerializer$.MODULE$).$plus((Serializer)MapSerializer$.MODULE$);
    private final Logger LOG = Logger.getLogger("ScalaRawSocketSender");
    private final String host;
    private final int port;
    private final int bufferCapacity;
    private final int timeout;
    private final String name;
    private final ByteBuffer pendings;
    private final InetSocketAddress server;
    private final ExponentialDelayReconnector reconnector;
    private Socket socket;
    private BufferedOutputStream out;

    public Formats formats() {
        return this.formats;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int bufferCapacity() {
        return this.bufferCapacity;
    }

    public int timeout() {
        return this.timeout;
    }

    public String name() {
        return this.name;
    }

    public ByteBuffer pendings() {
        return this.pendings;
    }

    public InetSocketAddress server() {
        return this.server;
    }

    public ExponentialDelayReconnector reconnector() {
        return this.reconnector;
    }

    public Socket socket() {
        return this.socket;
    }

    public void socket_$eq(Socket socket) {
        this.socket = socket;
    }

    public BufferedOutputStream out() {
        return this.out;
    }

    public void out_$eq(BufferedOutputStream bufferedOutputStream) {
        this.out = bufferedOutputStream;
    }

    public void open() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            this.LOG().severe(new StringBuilder().append((Object)"Failed to connect fluentd: ").append((Object)this.server().toString()).toString());
            this.LOG().severe("Connection will be retried");
            iOException.printStackTrace();
            this.close();
        }
    }

    public void connect() {
        try {
            this.socket_$eq(new Socket());
            this.socket().connect(this.server());
            this.socket().setSoTimeout(this.timeout());
            this.out_$eq(new BufferedOutputStream(this.socket().getOutputStream()));
            this.reconnector().clearErrorHistory();
            return;
        }
        catch (IOException iOException) {
            this.reconnector().addErrorHistory(System.currentTimeMillis());
            throw iOException;
        }
    }

    public void reconnect() {
        if (this.socket() == null) {
            this.connect();
        } else if (this.socket().isClosed() || !this.socket().isConnected()) {
            this.close();
            this.connect();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() {
        block11: {
            if (this.out() != null) {
                try {
                    this.out().close();
                }
                catch (IOException var1_1) {
                    this.out_$eq(null);
                }
            }
lbl8:
            // 4 sources

            if (this.socket() == null) break block11;
            try {
                this.socket().close();
            }
            finally {
                this.out_$eq(null);
            }
            ** GOTO lbl8
            catch (IOException var3_3) {
                this.socket_$eq(null);
            }
        }
        return;
        finally {
            this.socket_$eq(null);
        }
    }

    @Override
    public boolean emit(String tag, Map<String, Object> data) {
        return this.emit(tag, System.currentTimeMillis() / 1000L, data);
    }

    @Override
    public boolean emit(String tag, long timestamp, Map<String, Object> data) {
        return this.emit(new Event(tag, timestamp, data));
    }

    public boolean emit(Event event) {
        boolean exceptionResult1 = false;
        try {
            String json = Serialization$.MODULE$.write((Object)event, this.formats());
            this.send(json.getBytes("UTF-8"));
            return true;
        }
        catch (IOException iOException) {
            this.LOG().severe(new StringBuilder().append((Object)"Cannot serialize event: ").append((Object)event).toString());
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean send(byte[] bytes) {
        ScalaRawSocketSender scalaRawSocketSender = this;
        synchronized (scalaRawSocketSender) {
            if (this.pendings().position() + bytes.length > this.pendings().capacity()) {
                this.LOG().severe(new StringBuilder().append((Object)"Cannot send logs to ").append((Object)this.server().toString()).toString());
                return false;
            }
            this.pendings().put(bytes);
            if (this.reconnector().enableReconnection(System.currentTimeMillis())) {
                this.flush();
                return true;
            }
            return true;
        }
    }

    @Override
    public byte[] getBuffer() {
        int len = this.pendings().position();
        this.pendings().position(0);
        byte[] ret = new byte[len];
        this.pendings().get(ret, 0, len);
        return ret;
    }

    public Buffer clearBuffer() {
        return this.pendings().clear();
    }

    @Override
    public void flush() {
        ScalaRawSocketSender scalaRawSocketSender = this;
        synchronized (scalaRawSocketSender) {
            this.liftedTree1$1();
            return;
        }
    }

    @Override
    public String getName() {
        return this.name();
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - void declaration
     */
    private final Object liftedTree1$1() {
        void var1_1;
        Object exceptionResult2 = null;
        try {
            this.reconnect();
            this.out().write(this.getBuffer());
            this.out().flush();
            exceptionResult2 = this.clearBuffer();
        }
        catch (IOException iOException) {
            this.LOG().throwing(this.getClass().getName(), "flush", iOException);
            exceptionResult2 = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    public ScalaRawSocketSender(String h, int p, int to, int bufCap) {
        this.host = h;
        this.port = p;
        this.bufferCapacity = bufCap;
        this.timeout = to;
        this.name = Predef$.MODULE$.augmentString("%s_%d_%d_%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.port()), BoxesRunTime.boxToInteger((int)this.timeout()), BoxesRunTime.boxToInteger((int)this.bufferCapacity())}));
        this.pendings = ByteBuffer.allocate(this.bufferCapacity());
        this.server = new InetSocketAddress(this.host(), this.port());
        this.reconnector = new ExponentialDelayReconnector();
        this.socket = null;
        this.out = null;
        this.open();
    }

    public ScalaRawSocketSender(String host, int port) {
        this(host, port, 3000, 0x800000);
    }

    public ScalaRawSocketSender() {
        this("localhost", 24224);
    }
}

