/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.msgpack.MessagePack;
import org.msgpack.annotation.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Sender {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private MessagePack msgpack = new MessagePack();
    private SocketAddress server;
    private Socket socket;
    private String name;
    private int timeout;
    private BufferedOutputStream out;
    private ByteBuffer pendings;
    private ExponentialDelayReconnector reconnector;

    Sender() {
        this("localhost", 24224);
    }

    Sender(String host, int port) {
        this(host, port, 3000, 0x800000);
    }

    Sender(String host, int port, int timeout, int bufferCapacity) {
        this.pendings = ByteBuffer.allocate(bufferCapacity);
        this.server = new InetSocketAddress(host, port);
        this.name = String.format("%s_%d", host, port);
        this.reconnector = new ExponentialDelayReconnector();
        this.open();
    }

    public String getName() {
        return this.name;
    }

    private void open() {
        try {
            this.connect();
        }
        catch (IOException e) {
            LOG.error("Failed to connect fluentd: " + this.getName(), (Throwable)e);
            LOG.error("Connection will be retried");
            this.close();
        }
    }

    private void connect() throws IOException {
        try {
            this.socket = new Socket();
            this.socket.connect(this.server);
            this.socket.setSoTimeout(this.timeout);
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.reconnector.clearErrorHistory();
        }
        catch (IOException e) {
            this.reconnector.addErrorHistory(System.currentTimeMillis());
            throw e;
        }
    }

    private void reconnect() throws IOException {
        if (this.socket == null) {
            this.connect();
        } else if (this.socket.isClosed() || !this.socket.isConnected()) {
            this.close();
            this.connect();
        }
    }

    public void close() {
        block12: {
            if (this.out != null) {
                try {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        this.out = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.out = null;
                    throw throwable;
                }
                this.out = null;
            }
        }
        if (this.socket != null) {
            try {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    this.socket = null;
                }
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void emit(String tag, Map<String, String> data) {
        this.emit(new Event(tag, System.currentTimeMillis(), data));
    }

    void emit(String tag, long timestamp, Map<String, String> data) {
        this.emit(new Event(tag, timestamp, data));
    }

    private void emit(Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Created %s", event));
        }
        byte[] bytes = null;
        try {
            bytes = this.msgpack.write((Object)event);
        }
        catch (IOException e) {
            LOG.error("Cannot serialize event: " + event, (Throwable)e);
        }
        if (bytes != null) {
            this.send(bytes);
        }
    }

    private synchronized void send(byte[] bytes) {
        this.appendBuffer(bytes);
        try {
            if (!this.reconnector.enableReconnection(System.currentTimeMillis())) {
                return;
            }
            this.reconnect();
            this.out.write(this.getBuffer());
            this.out.flush();
            this.clearBuffer();
        }
        catch (IOException e) {
            this.close();
        }
    }

    void appendBuffer(byte[] bytes) {
        if (this.pendings.position() + bytes.length > this.pendings.capacity()) {
            LOG.error("FluentLogger: Cannot send logs to " + this.getName());
            this.pendings.clear();
        }
        this.pendings.put(bytes);
    }

    byte[] getBuffer() {
        int len = this.pendings.position();
        this.pendings.position(0);
        byte[] ret = new byte[len];
        this.pendings.get(ret, 0, len);
        return ret;
    }

    void clearBuffer() {
        this.pendings.clear();
    }

    public static void main(String[] args) throws Exception {
        Sender sender = new Sender("localhost", 24224);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("t1k1", "t1v1");
        data.put("t1k2", "t1v2");
        sender.emit("tag.label1", data);
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("t2k1", "t2v1");
        data2.put("t2k2", "t2v2");
        sender.emit("tag.label2", data2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Message
    public static class Event {
        public String tag;
        public long timestamp;
        public Map<String, String> data;

        public Event() {
        }

        public Event(String tag, long timestamp, Map<String, String> data) {
            this.tag = tag;
            this.timestamp = timestamp;
            this.data = data;
        }

        public String toString() {
            return String.format("Event[tag=%s,timestamp=%d,data=%s]", this.tag, this.timestamp, this.data.toString());
        }
    }

    private static class ExponentialDelayReconnector {
        private double wait = 0.5;
        private double waitIncrRate = 1.5;
        private double waitMax = 60.0;
        private int waitMaxCount = this.getWaitMaxCount();
        private LinkedList<Long> errorHist = new LinkedList();

        private int getWaitMaxCount() {
            double r = this.waitMax / this.wait;
            int j = 1;
            while (j <= 100) {
                if (r < this.waitIncrRate) {
                    return j + 1;
                }
                r /= this.waitIncrRate;
                ++j;
            }
            return 100;
        }

        public void addErrorHistory(long timestamp) {
            this.errorHist.addLast(timestamp);
            if (this.errorHist.size() > this.waitMaxCount) {
                this.errorHist.removeFirst();
            }
        }

        public void clearErrorHistory() {
            this.errorHist.clear();
        }

        public boolean enableReconnection(long timestamp) {
            int size = this.errorHist.size();
            if (size == 0) {
                return true;
            }
            double suppressSec = size < this.waitMaxCount ? this.wait * Math.pow(this.waitIncrRate, size - 1) : this.waitMax;
            return !((double)(timestamp - this.errorHist.getLast()) < suppressSec);
        }
    }
}

