/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger;

import java.util.HashMap;
import java.util.Map;
import org.fluentd.logger.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentLogger {
    private static Map<String, FluentLogger> loggers = new HashMap<String, FluentLogger>();
    private String tagPrefix;
    private Sender sender;

    public static FluentLogger getLogger(String tag) {
        return FluentLogger.getLogger(tag, "localhost", 24224);
    }

    public static FluentLogger getLogger(String tag, String host, int port) {
        return FluentLogger.getLogger(tag, host, port, 3000, 0x100000);
    }

    public static synchronized FluentLogger getLogger(String tag, String host, int port, int timeout, int bufferCapacity) {
        String key = String.format("%s_%s_%d_%d_%d", tag, host, port, timeout, bufferCapacity);
        if (loggers.containsKey(key)) {
            return loggers.get(key);
        }
        FluentLogger logger = new FluentLogger(tag, host, port, timeout, bufferCapacity);
        loggers.put(key, logger);
        return logger;
    }

    public static synchronized void close() {
        for (FluentLogger logger : loggers.values()) {
            logger.close0();
        }
    }

    private FluentLogger(String tag, String host, int port, int timeout, int bufferCapacity) {
        this.tagPrefix = tag;
        this.sender = new Sender(host, port, timeout, bufferCapacity);
    }

    public void log(String label, Map<String, String> data) {
        this.sender.emit(this.tagPrefix + "." + label, data);
    }

    public void log(String label, String key, String value) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        this.sender.emit(this.tagPrefix + "." + label, data);
    }

    private void close0() {
        if (this.sender != null) {
            this.sender.close();
            this.sender = null;
        }
    }
}

