/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.template.Templates;
import org.msgpack.unpacker.Unpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Sender {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private MessagePack msgpack = new MessagePack();
    private SocketAddress server;
    private Socket socket;
    private String name;
    private int timeout;
    private BufferedOutputStream out;
    private ByteBuffer pendings;
    private ExponentialDelayReconnector reconnector;

    Sender() {
        this("localhost", 24224);
    }

    Sender(String host, int port) {
        this(host, port, 3000, 0x800000);
    }

    Sender(String host, int port, int timeout, int bufferCapacity) {
        this.msgpack.register(Event.class, (Template)EventTemplate.INSTANCE);
        this.pendings = ByteBuffer.allocate(bufferCapacity);
        this.server = new InetSocketAddress(host, port);
        this.name = String.format("%s_%d", host, port);
        this.reconnector = new ExponentialDelayReconnector();
        this.open();
    }

    public String getName() {
        return this.name;
    }

    private void open() {
        try {
            this.connect();
        }
        catch (IOException e) {
            LOG.error("Failed to connect fluentd: " + this.getName(), (Throwable)e);
            LOG.error("Connection will be retried");
            this.close();
        }
    }

    private void connect() throws IOException {
        try {
            this.socket = new Socket();
            this.socket.connect(this.server);
            this.socket.setSoTimeout(this.timeout);
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.reconnector.clearErrorHistory();
        }
        catch (IOException e) {
            this.reconnector.addErrorHistory(System.currentTimeMillis());
            throw e;
        }
    }

    private void reconnect() throws IOException {
        if (this.socket == null) {
            this.connect();
        } else if (this.socket.isClosed() || !this.socket.isConnected()) {
            this.close();
            this.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
            }
            finally {
                this.out = null;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void emit(String tag, Map<String, String> data) {
        this.emit(new Event(tag, System.currentTimeMillis(), data));
    }

    void emit(String tag, long timestamp, Map<String, String> data) {
        this.emit(new Event(tag, timestamp, data));
    }

    private void emit(Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Created %s", event));
        }
        byte[] bytes = null;
        try {
            bytes = this.msgpack.write((Object)event);
        }
        catch (IOException e) {
            LOG.error("Cannot serialize event: " + event, (Throwable)e);
        }
        if (bytes != null) {
            this.send(bytes);
        }
    }

    private synchronized void send(byte[] bytes) {
        this.appendBuffer(bytes);
        try {
            if (!this.reconnector.enableReconnection(System.currentTimeMillis())) {
                return;
            }
            this.reconnect();
            this.out.write(this.getBuffer());
            this.out.flush();
            this.clearBuffer();
        }
        catch (IOException e) {
            this.close();
        }
    }

    void appendBuffer(byte[] bytes) {
        if (this.pendings.position() + bytes.length > this.pendings.capacity()) {
            LOG.error("FluentLogger: Cannot send logs to " + this.getName());
            this.pendings.clear();
        }
        this.pendings.put(bytes);
    }

    byte[] getBuffer() {
        int len = this.pendings.position();
        this.pendings.position(0);
        byte[] ret = new byte[len];
        this.pendings.get(ret, 0, len);
        return ret;
    }

    void clearBuffer() {
        this.pendings.clear();
    }

    public static void main(String[] args) throws Exception {
        Sender sender = new Sender("localhost", 24224);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("t1k1", "t1v1");
        data.put("t1k2", "t1v2");
        sender.emit("tag.label1", data);
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("t2k1", "t2v1");
        data2.put("t2k2", "t2v2");
        sender.emit("tag.label2", data2);
    }

    private static class ExponentialDelayReconnector {
        private double wait = 0.5;
        private double waitIncrRate = 1.5;
        private double waitMax = 60.0;
        private int waitMaxCount = this.getWaitMaxCount();
        private LinkedList<Long> errorHistory = new LinkedList();

        private int getWaitMaxCount() {
            double r = this.waitMax / this.wait;
            for (int j = 1; j <= 100; ++j) {
                if (r < this.waitIncrRate) {
                    return j + 1;
                }
                r /= this.waitIncrRate;
            }
            return 100;
        }

        public void addErrorHistory(long timestamp) {
            this.errorHistory.addLast(timestamp);
            if (this.errorHistory.size() > this.waitMaxCount) {
                this.errorHistory.removeFirst();
            }
        }

        public void clearErrorHistory() {
            this.errorHistory.clear();
        }

        public boolean enableReconnection(long timestamp) {
            int size = this.errorHistory.size();
            if (size == 0) {
                return true;
            }
            double suppressSec = size < this.waitMaxCount ? this.wait * Math.pow(this.waitIncrRate, size - 1) : this.waitMax;
            return !((double)(timestamp - this.errorHistory.getLast()) < suppressSec);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventTemplate
    extends AbstractTemplate<Event> {
        static EventTemplate INSTANCE = new EventTemplate();

        public void write(Packer pk, Event v, boolean required) throws IOException {
            if (v == null) {
                if (required) {
                    throw new MessageTypeException("Attempted to write null");
                }
                pk.writeNil();
                return;
            }
            pk.writeArrayBegin(3);
            Templates.TString.write(pk, (Object)v.tag, required);
            Templates.TLong.write(pk, (Object)v.timestamp, required);
            pk.writeMapBegin(v.data.size());
            for (Map.Entry<String, String> e : v.data.entrySet()) {
                Templates.TString.write(pk, (Object)e.getKey(), required);
                Templates.TString.write(pk, (Object)e.getValue(), required);
            }
            pk.writeMapEnd();
            pk.writeArrayEnd();
        }

        public Event read(Unpacker u, Event to, boolean required) throws IOException {
            if (!required && u.trySkipNil()) {
                return null;
            }
            to = new Event();
            u.readArrayBegin();
            to.tag = (String)Templates.TString.read(u, null, required);
            to.timestamp = (Long)Templates.TLong.read(u, null, required);
            int size = u.readMapBegin();
            to.data = new HashMap<String, String>(size);
            for (int i = 0; i < size; ++i) {
                String key = (String)Templates.TString.read(u, null, required);
                String value = (String)Templates.TString.read(u, null, required);
                to.data.put(key, value);
            }
            u.readMapEnd();
            u.readArrayEnd();
            return to;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Event {
        public String tag;
        public long timestamp;
        public Map<String, String> data;

        public Event() {
        }

        public Event(String tag, long timestamp, Map<String, String> data) {
            this.tag = tag;
            this.timestamp = timestamp;
            this.data = data;
        }

        public String toString() {
            return String.format("Event { tag=%s, timestamp=%d, data=%s }", this.tag, this.timestamp, this.data.toString());
        }
    }
}

