/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger.sender;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.fluentd.logger.sender.ExponentialDelayReconnector;
import org.fluentd.logger.sender.Reconnector;

public class ConstantDelayReconnector
implements Reconnector {
    private static final Logger LOG = Logger.getLogger(ExponentialDelayReconnector.class.getName());
    private double wait = 50.0;
    private int maxErrorHistorySize = 100;
    private LinkedList<Long> errorHistory = new LinkedList();

    public ConstantDelayReconnector() {
        this.errorHistory = new LinkedList();
    }

    public ConstantDelayReconnector(int wait) {
        this.wait = wait;
        this.errorHistory = new LinkedList();
    }

    @Override
    public void addErrorHistory(long timestamp) {
        this.errorHistory.addLast(timestamp);
        if (this.errorHistory.size() > this.maxErrorHistorySize) {
            this.errorHistory.removeFirst();
        }
    }

    @Override
    public boolean isErrorHistoryEmpty() {
        return this.errorHistory.isEmpty();
    }

    @Override
    public void clearErrorHistory() {
        this.errorHistory.clear();
    }

    @Override
    public boolean enableReconnection(long timestamp) {
        int size = this.errorHistory.size();
        if (size == 0) {
            return true;
        }
        return !((double)(timestamp - this.errorHistory.getLast()) < this.wait);
    }
}

